/*

*/

package renderer.scene.primitives;
import  renderer.scene.Model;

import java.util.List;
import java.util.ArrayList;
import java.awt.Color;

/**
   A {@code Face} object has a list of integers that represent
   the endpoints of a closed loop of line  segments. The
   integers are indices into the {@link Vertex} list of a
   {@link Model} object.
<p>
   A {@code Face} is closed loop of line segments that is assumed
   to be "flat" and "convex".
<p>
   Flat means that the vertices of the {@code Face} all lie in
   the same plane.
<p>
   Convex means that a line segment joining any two vertices of
   the {@code Face} must be completely contained inside of the
   {@code Face}.
<p>
   The combination of flat and convex means that we can give a
   {@code Face} an orientation and we can determine if the
   {@code Face} if "front facing" or "back facing".
*/
public class Face extends OrientablePrimitive
{
   /**
      Construct a {@code Face} with the given array of indices for
      the vertex and color index lists.
      <p>
      NOTE: This constructor does not put any Vertex or Color objects into
      this Face's Model. This constructor assumes that the given indices
      are valid (or will be valid by the time this Face gets rendered).

      @param indices  array of vertex and color indices to place in this {@code Face}
   */
   public Face(int... indices)
   {
      super(indices);
   }


   /**
      Implement the {@link #makeCopy()} method from the {@link Primitive} abstract base class.
      <p>
      Construct a deep copy of this {@code Face} object.

      @return a {@code Face} object that is a deep copy of this {@code Face}
   */
   public Face makeCopy()
   {
      Face result = new Face();
      for (int i = 0; i < this.vIndexList.size(); i++)
      {
         result.addIndices(vIndexList.get(i),
                           cIndexList.get(i),
                           cIndexList2.get(i));
      }
      return result;
   }


   /**
      For debugging.

      @return {@link String} representation of this {@code Face} object
   */
   @Override
   public String toString()
   {
      String result =  "Face: ([";
      for (int i = 0; i < vIndexList.size() - 1; i++)
      {
         result += vIndexList.get(i) + ", ";
      }
      result += vIndexList.get(vIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList.size() - 1; i++)
      {
         result += cIndexList.get(i) + ", ";
      }
      result += cIndexList.get(cIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList2.size() - 1; i++)
      {
         result += cIndexList2.get(i) + ", ";
      }
      result += cIndexList2.get(cIndexList2.size() - 1) + "])\n";
      return result;
   }
}
