/*

*/

package renderer.scene.primitives;

import java.util.List;
import java.util.ArrayList;

/**
   A {@code LineFan} object has {@code n+1} integers that
   represent the endpoints of {@code n} line segments that
   radiate from a central point and another {@code n+1}
   integers that represent the color at each of those endpoints.
<p>
   The integers are indices into the {@link Vertex} and {@link Color}
   lists of a {@link Model} object.
*/
public class LineFan extends Primitive
{
   /**
      Construct a {@code LineFan} with the given array of indices for
      the vertex and color index lists.
      <p>
      NOTE: This constructor does not put any Vertex or Color objects into
      this Primitive's Model. This constructor assumes that the given indices
      are valid (or will be valid by the time this Primitive gets rendered).

      @param indices  array of vertex and color indices to place in this {@code LineFan}
   */
   public LineFan(int... indices)
   {
      super(indices);
   }


   /**
      Implement the {@link #makeCopy()} method from the {@link Primitive} abstract base class.
      <p>
      Construct a deep copy of this {@code LineFan} object.

      @return a {@code LineFan} object that is a deep copy of this {@code LineFan} object
   */
   @Override
   public LineFan makeCopy() // a kind of "copy constructor"
   {
      LineFan result = new LineFan();
      for (int i = 0; i < this.vIndexList.size(); i++)
      {
         result.addIndices(vIndexList.get(i), cIndexList.get(i));
      }
      return result;
   }


   /**
      For debugging.

      @return {@link String} representation of this {@code LineFan} object
   */
   @Override
   public String toString()
   {
      String result =  "LineFan: ([";
      for (int i = 0; i < vIndexList.size() - 1; i++)
      {
         result += vIndexList.get(i) + ", ";
      }
      result += vIndexList.get(vIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList.size() - 1; i++)
      {
         result += cIndexList.get(i) + ", ";
      }
      result += cIndexList.get(cIndexList.size() - 1) + "])\n";
      return result;
   }
}
