/*

*/

package renderer.scene.primitives;

import java.util.List;
import java.util.ArrayList;

/**
   A {@code LineLoop} object has {@code n} integers that
   represent the endpoints of {@code n} contiguous line segments
   that form a closed loop and another {@code n} integers that
   represent the color at each of those endpoints.
<p>
   The integers are indices into the {@link Vertex} and {@link Color}
   lists of a {@link Model} object.
*/
public class LineLoop extends Primitive
{
   /**
      Construct a {@code LineLoop} with the given array of indices for
      the vertex and color index lists.
      <p>
      NOTE: This constructor does not put any Vertex or Color objects into
      this Primitive's Model. This constructor assumes that the given indices
      are valid (or will be valid by the time this Primitive gets rendered).

      @param indices  array of vertex and color indices to place in this {@code LineLoop}
   */
   public LineLoop(int... indices)
   {
      super(indices);
   }


   /**
      Implement the {@link #makeCopy()} method from the {@link Primitive} abstract base class.
      <p>
      Construct a deep copy of this {@code LineLoop} object.

      @return a {@code LineLoop} object that is a deep copy of this {@code LineLoop} object
   */
   @Override
   public LineLoop makeCopy() // a kind of "copy constructor"
   {
      LineLoop result = new LineLoop();
      for (int i = 0; i < this.vIndexList.size(); i++)
      {
         result.addIndices(vIndexList.get(i), cIndexList.get(i));
      }
      return result;
   }


   /**
      For debugging.

      @return {@link String} representation of this {@code LineLoop} object
   */
   @Override
   public String toString()
   {
      String result =  "LineLoop: ([";
      for (int i = 0; i < vIndexList.size() - 1; i++)
      {
         result += vIndexList.get(i) + ", ";
      }
      result += vIndexList.get(vIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList.size() - 1; i++)
      {
         result += cIndexList.get(i) + ", ";
      }
      result += cIndexList.get(cIndexList.size() - 1) + "])\n";
      return result;
   }
}
