/*

*/

package renderer.scene.primitives;
import  renderer.scene.Model;

import java.util.List;
import java.util.ArrayList;
import java.awt.Color;

/**
   A {@code Point} object has two integers that represent
   the location and color of a single {@link Vertex}. The first
   integer is an index into the {@link Vertex} list of a {@link Model}
   object and the second integer is an index into the {@link Color}
   list of that {@link Model} object.
*/
public class Point extends Primitive
{
   public int radius = 0;

   /**
      Construct a {@code Point} object using an integer index.
      Use the given index for both the {@link Vertex} and the
      {@link Color} lists.

      @param i  index for the {@link Vertex} and {@link Color} of the new {@code Point}
   */
   public Point(int i)
   {
      this(i, i);
   }


   /**
      Construct a {@code Point} object using two integer indices, one
      for the {@link Vertex} list and one for the {@link Color} list.
      <p>
      NOTE: This method does not put any Vertex or Color objects into
      this Point's Model. This method assumes that the given indices
      are valid (or will be valid by the time this Point gets rendered).

      @param v  index for the {@link Vertex} of the new {@code Point}
      @param c  index for the {@link Color} of the new {@code Point}
   */
   public Point(int v, int c)
   {
      super();

      vIndexList.add(v);
      cIndexList.add(c);
   }


   /**
      Implement the {@link #makeCopy()} method from the {@link Primitive} abstract base class.
      <p>
      Construct a deep copy of this {@code Point} primitive.

      @return a {@code Point} object that is a deep copy of this {@code Point} object
   */
   @Override
   public Point makeCopy() // a kind of "copy constructor"
   {
      Point result = new Point(this.vIndexList.get(0),
                               this.cIndexList.get(0));
      result.radius = this.radius;
      return result;
   }


   /**
      For debugging.

      @return {@link String} representation of this {@code Point} object
   */
   @Override
   public String toString()
   {
      return "Point: ([" + vIndexList.get(0) + "], "
                   + "[" + cIndexList.get(0) + "]) radius = " + radius + "\n";
   }
}
