/*

*/

package renderer.scene.primitives;
import  renderer.scene.Model;

import java.util.List;
import java.util.ArrayList;
import java.awt.Color;

/**
   A {@code TriangleStrip} object has {@code n+2} integers that
   represent the vertices of {@code n} contiguous triangles
   and another {@code n+2} integers that represent the color at
   each of those vertices.
<p>
   The integers are indices into the {@link Vertex} and {@link Color}
   lists of a {@link Model} object.
<p>
   See
     <a href="https://en.wikipedia.org/wiki/Triangle_strip" target="_top">
              https://en.wikipedia.org/wiki/Triangle_strip</a>
*/
public class TriangleStrip extends OrientablePrimitive
{
   /**
      Construct a {@code TriangleStrip} with the given array of indices for
      the vertex and color index lists.
      <p>
      NOTE: This constructor does not put any Vertex or Color objects into
      this Primitive's Model. This constructor assumes that the given indices
      are valid (or will be valid by the time this Primitive gets rendered).

      @param indices  array of vertex and color indices to place in this {@code TriangleStrip}
   */
   public TriangleStrip(int... indices)
   {
      super(indices);
   }


   /**
      Implement the {@link #makeCopy()} method from the {@link Primitive} abstract base class.
      <p>
      Construct a deep copy of this {@code TriangleStrip} object.

      @return a {@code TriangleStrip} object that is a deep copy of this {@code TriangleStrip} object
   */
   @Override
   public TriangleStrip makeCopy() // a kind of "copy constructor"
   {
      TriangleStrip result = new TriangleStrip();
      for (int i = 0; i < this.vIndexList.size(); i++)
      {
         result.addIndices(vIndexList.get(i),
                           cIndexList.get(i),
                           cIndexList2.get(i));
      }
      return result;
   }


   /**
      For debugging.

      @return {@link String} representation of this {@code TriangleStrip} object
   */
   @Override
   public String toString()
   {
      String result =  "TriangleStrip: ([";
      for (int i = 0; i < vIndexList.size() - 1; i++)
      {
         result += vIndexList.get(i) + ", ";
      }
      result += vIndexList.get(vIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList.size() - 1; i++)
      {
         result += cIndexList.get(i) + ", ";
      }
      result += cIndexList.get(cIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList2.size() - 1; i++)
      {
         result += cIndexList2.get(i) + ", ";
      }
      result += cIndexList2.get(cIndexList2.size() - 1) + "])\n";
      return result;
   }
}
