/*

*/

package renderer.scene.primitives;
import  renderer.scene.Model;

import java.util.List;
import java.util.ArrayList;
import java.awt.Color;

/**
   A {@code Triangles} object has {@code 3n} integers that
   represent the vertices of {@code n} triangles
   and another {@code 3n} integers that represent the
   color at each of those vertices.
<p>
   The integers are indices into the {@link Vertex} and {@link Color}
   lists of a {@link Model} object.
*/
public class Triangles extends OrientablePrimitive
{
   /**
      Construct a {@code Triangles} with the given array of indices for
      the vertex and color index lists.
      <p>
      NOTE: This constructor does not put any Vertex or Color objects into
      this Primitive's Model. This constructor assumes that the given indices
      are valid (or will be valid by the time this Primitive gets rendered).

      @param indices  array of vertex and color indices to place in this {@code Triangles}
   */
   public Triangles(int... indices)
   {
      super(indices);
   }


   /**
      Implement the {@link #makeCopy()} method from the {@link Primitive} abstract base class.
      <p>
      Construct a deep copy of this {@code Triangles} object.

      @return a {@code Triangles} object that is a deep copy of this {@code Triangles} object
   */
   @Override
   public Triangles makeCopy() // a kind of "copy constructor"
   {
      Triangles result = new Triangles();
      for (int i = 0; i < this.vIndexList.size(); i++)
      {
         result.addIndices(vIndexList.get(i),
                           cIndexList.get(i),
                           cIndexList2.get(i));
      }
      return result;
   }


   /**
      For debugging.

      @return {@link String} representation of this {@code Triangles} object
   */
   @Override
   public String toString()
   {
      String result =  "Triangles: ([";
      for (int i = 0; i < vIndexList.size() - 1; i++)
      {
         result += vIndexList.get(i) + ", ";
      }
      result += vIndexList.get(vIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList.size() - 1; i++)
      {
         result += cIndexList.get(i) + ", ";
      }
      result += cIndexList.get(cIndexList.size() - 1) + "], [";
      for (int i = 0; i < cIndexList2.size() - 1; i++)
      {
         result += cIndexList2.get(i) + ", ";
      }
      result += cIndexList2.get(cIndexList2.size() - 1) + "])\n";
      return result;
   }
}
