/*
 * Renderer 3. The MIT License.
 * Copyright (c) 2022 rlkraft@pnw.edu
 * See LICENSE for details.
*/


/**
   This program shows how subtle floating point
   arithmetic can be. It also shows that it is
   better, from a numerical accuracy point of view,
   to write the linear interpolation formula
         (1-t)*a + t*b
   in this slightly less clear way
         a + t*(b - a).
*/
public class InterpolationExample
{
   public static void main(String[] args)
   {
      final double t = 0.190216973423958;
      final float tf = 0.190216973423958f;
      System.out.printf("% .32f\n", (1-t)    *(1.0)  + t *(1.0));  // all doubles
      System.out.printf("% .32f\n", (1-tf)   *(1.0)  + tf*(1.0));  // mix of double and float
      System.out.printf("% .32f\n", (1.0-tf) *(1.0)  + tf*(1.0));  // mix of double and float
      System.out.printf("% .16f\n", (1.0f-tf)*(1.0f) + tf*(1.0f)); // all floats
   }
}
