import java.awt.*
import java.awt.event.*
import javax.swing.*
import javax.swing.event.*
import renderer.framebuffer.*
import renderer.scene.*
import renderer.scene.primitives.*
import renderer.scene.util.*
import renderer.models_L.*
import renderer.pipeline.*

var scene = new Scene("extreme-clipping-example")
var m = new Model("clipping-example")
m.addVertex(new Vertex( 1.25,  1.5, 0))
m.addVertex(new Vertex(-1.25, -1.5, 0))
m.addColor(new Color(255, 0, 0))
m.addColor(new Color(0, 0, 255))
m.addPrimitive(new LineSegment(0, 1, 0, 1))
var p = new Position(m, "p0")
p.translate(0, 0, -1)
scene.addPosition(p)

scene.debug = true
Clip.debug = true
Rasterize.debug = false
var fbp = new FrameBufferPanel(400, 400, Color.white)
Pipeline.render(scene, fbp.getFrameBuffer())

var jf = new JFrame("Renderer 3, Clipping")
jf.add(fbp)
jf.pack()
jf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE)
jf.setVisible(true)

/list
