/*
 * Renderer 5. The MIT License.
 * Copyright (c) 2022 rlkraft@pnw.edu
 * See LICENSE for details.
*/

import renderer.scene.*;
import renderer.pipeline.*;
import renderer.framebuffer.*;

import java.awt.Color;

/**
  Run this program and then resize the window so that it is no longer
  a square window. Notice how the circle is distorted into an ellipse.
<p>
  When you resize the window, the aspect ratio of the framebuffer's
  viewport no longer matches the aspect ratio of the view rectangle in
  view coordinates (that is, the aspect ratio of the near plane of the
  camera's view volume). The renderer distorts the contents of the
  view rectangle to fit into the viewport when the renderer does
  the viewplane-to-pixelplane transformation.
<p>
  We can fix this by having Java's resize window event handler create
  a new viewport within the FrameBuffer every time there is a "reshape"
  event and set the viewport to always have the same aspect ratio as
  the camera's view rectangle (see the next program, Circle_v2_Letterbox.java).
*/
@SuppressWarnings("serial")
public class Circle_v1_Distort extends Circle_v0_Abstract
{
   /**
      This constructor instantiates the Scene object
      and initializes it with appropriate geometry.
      Then this constructor instantiates the GUI.
   */
   public Circle_v1_Distort()
   {
      super("Renderer 5 - Distort");
      print_help_message();
   }


   /**
      Create an instance of this class which has
      the affect of creating the GUI application.
   */
   public static void main(String[] args)
   {
      // We need to call the program's constructor in the
      // Java GUI Event Dispatch Thread, otherwise we get a
      // race condition between the constructor (running in
      // the main() thread) and the very first ComponentEvent
      // (running in the EDT).
      javax.swing.SwingUtilities.invokeLater(
         () -> new Circle_v1_Distort()
      );
   }
}
