import java.awt.*
import java.awt.event.*
import javax.swing.*
import javax.swing.event.*
import renderer.framebuffer.*
import renderer.scene.*
import renderer.scene.primitives.*
import renderer.scene.util.*
import renderer.models_L.*
import renderer.pipeline.*

var scene = new Scene("view-volume-example")
scene = scene.changeCamera( Camera.projPerspective(-2, 2, -1, 1) )
var p0 = new Position(new Sphere(), "p0")
var p1 = new Position(new Cube3(8, 8, 8), "p1")
ModelShading.setColor(p0.getModel(), Color.red)
ModelShading.setColor(p1.getModel(), Color.blue)
p0.translate(1.5, -0.5, -2)
p1.translate(-2.0, 0.5, -3)
scene.addPosition(p0, p1)

var fbp = new FrameBufferPanel(600, 300, Color.cyan)
fbp.addComponentListener(new ComponentAdapter(){ 
   @Override public void componentResized(ComponentEvent e) {
      var w_fb = fbp.getWidth();
      var h_fb = fbp.getHeight();
      var fb = new FrameBuffer(w_fb, h_fb, Color.cyan);
      var h_vp = (w_fb / h_fb) >= 2 ? h_fb : w_fb / 2;
      var w_vp = 2 * h_vp;
      fb.setViewport((w_fb - w_vp)/2, (h_fb - h_vp)/2, w_vp, h_vp);
      fb.vp.clearVP(Color.white);      
      Pipeline.render(scene, fb);
      fbp.setFrameBuffer(fb);
      fbp.repaint();
   }
})

var jf = new JFrame("Renderer 5, View Volumes")
jf.add(fbp)
jf.pack()
jf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE)
jf.setVisible(true)

/list
