/*
   A Tree is defined by the following grammar.

     Tree ::= '(' String Tree+ ')'
            | String

   where '(' and ')' are literals, and Tree+ means "one or more".

   This language also assumes that all tokens have white space around them.

   The static method getTree() is essentially a recursive descent
   parser for this Tree langauge.
*/

public class BuildTree
{
   public static Tree buildTree(String expression)
   {
      Tokenizer tokens = new Tokenizer(expression);  // Tokenizer is defined
                                                     // in Tokenizer.java
      Tree result = getTree(tokens); // parse the tokens

      if ( tokens.hasToken() )  // there shouldn't be any more tokens
         throw new Error("syntax error: unexpected input: "+tokens.peekToken()+"\n"+tokens);

      return result;
   }//buildTree()


   private static Tree getTree(Tokenizer tokens)
   {
      Tree result;
      String token = tokens.nextToken(); // consume one token
      if ( token.equals("(") )           // look for a parenthesized tree
      {
         result = new Tree( tokens.nextToken() ); // consume the root of the tree
         result.addSubTree( getTree(tokens) );    // consume first sub tree
         token = tokens.peekToken();              // one token look ahead
         while ( !token.equals(")") )
         {
            result.addSubTree( getTree(tokens) ); // consume the sub tree
            token = tokens.peekToken();           // one token look ahead
         }
         tokens.match(")");              // consume the matching ")"
      }
      else
      {
         result = new Tree(token);       // the tree must be just the root
      }
      return result;
   }//getTree()

}//BuildTree
