/*
   This program parses and then evaluates strings from Language-15.
*/

public class Examples
{
   public static void main(String[] args)
   {
      String expr1 = "( prog " +
                       "( begin ( var x1 10 ) " +
                             "( var x2 ( sym ok ) ) " +
                             "( print ( var x3 ( list x1 100 true x2 ( list 1 2 3 ) w ) ) ) " +
                             "( print ( empty? ( cdr x3 ) ) ) " +
                             "( print ( car x3 ) ) " +
                             "( var x4 ( cons ( sym pear ) ( cdr x3 ) ) ) ) )";

      String expr2 = "( prog ( cons 5 ( cdr ( cdr ( list 1 2 ) ) ) ) )";

      String expr3 = "( prog ( cons ( sym 1a ) ( cons ( list 2a 2b 02c 02 ) ( cons 03 ( list a b c ) ) ) ) )";

      String expr4 = "( prog ( list 1 ( list 2 3 4 5 ) ) )";

      String expr5 = "( prog ( cons 1 ( list 2 3 4 5 ) ) )";

      String expr6 = "( prog " +
                       "( var reduce " +
                           "( lambda  op l " +  // op is a function, l is a list
                             "( if ( empty? ( cdr l ) ) " +
                                  "( car l ) " +
                                  "( op ( car l ) ( reduce op ( cdr l ) ) ) ) ) ) " +
                       "( print ( reduce + ( list 1 2 3 4 5 6 7 ) ) ) " +
                       "( print ( reduce * ( list 1 2 3 4 5 6 7 ) ) ) )";


      String expr = expr1;

      // print the original expression
      System.out.println( expr + "\n" );

      // preporcess the expression
      expr = Preprocessor.preprocess(expr);

      // build the abstract syntax tree that represents the expression
      Tree ast = BuildTree.buildTree( expr );

      // print the preprocessed expression
      System.out.println( expr + "\n" );
      // pretty-print the abstract syntax tree
      System.out.println( PrettyPrinter3.prettyPrint( ast ) + "\n" );
      // print the infix version of the expression
      System.out.println( AST2infix.ast2infix( ast ) + "\n" );

      try
      {
         // evaluate the expression (interpret the AST)
         Value value = Evaluate.evaluate( ast );

         System.out.println( "\nresult = " + value );
      }
      catch (EvalException e)
      {
         e.printStackTrace();
      }
   }//main

}//Examples