(define lst1 '(1 2 3 4))

(define lst2 (cons (cdr lst1) lst1))

lst2

(set-car! (cddr lst2) 20)

; we changed lst2 in one place, but it really changed in two places
lst2

(define lst1 '(1 2 3 4))
(define lst2 (cons (car lst1) (cdr lst1)))
; are lst1 and lst2 "the same"?
lst1
lst2
(equal? lst1 lst2)
(eq? lst1 lst2)
(set-car! lst2 10) ; this changes only lst2
lst1
lst2
(set-car! (cdr lst2) 20) ; this changes both lst1 and lst2
lst1
lst2


; What does it mean to append an item to the end of a list?

; The following function walks to the end of the given list,
; then "attaches" the item to the end of the list.
; (This is a very C\C++\Java like imperative function.)
(define append-v1
  (lambda (list item)
    (define helper
      (lambda (list1)
        (if (null? list1)
            (cons item list1)
            (if (null? (cdr list1)) ; list1 has one item
                (begin
                   (set-cdr! list1 (cons item '()))
                   list)             ; return value for helper
                (helper (cdr list1)) ; walk down the list
        ))))
    (helper list)))

(append-v1 '(a b c) 'd)
(append-v1 lst2 10101)

; The following function returns a "new" list which has the
; item at the end of the original list.
(define append-v2
  (lambda (list item)
    (define helper
      (lambda (list1)
        (if (null? list1)
            (cons item list1)
            (cons (car list1) (helper (cdr list1)))
        )))
    (helper list)))

(append-v2 '(a b c) 'd)
(append-v2 lst2 10101)

; Here is another way to define the previous function.
(define append-v3
  (lambda (list item)
    (if (null? list)
        (cons item list)
        (cons (car list) (append-v3 (cdr list) item)))))

(append-v3 '(a b c) 'd)
(append-v3 lst2 10101)

; Here is kind of a dumb way to define append.
(define append-v4
  (lambda (list item)
    (reverse (cons item (reverse list)))))


; Consider how the following two functions work
; when we use either append-v1 or append-v2.
(define reverse-v1
  (lambda (list)
    (if (null? list)
        list
        (append-v1 (reverse-v1 (cdr list)) (car list)))))

(reverse-v1 '(a b c d))
(reverse-v1 lst1)
lst1

(define reverse-v2
  (lambda (list)
    (if (or (null? list) (null? (cdr list)))
        list
        (append-v1 (reverse-v2 (cdr list)) (car list)))))

(reverse-v2 '(a b c d))
(reverse-v2 lst1)
lst1   ; Notice what happens here! Why?



; Just for the sake of completeness,
; here is the "correct" way to write reverse.
(define reverse-v3
  (lambda (list)
    (define helper
      (lambda (list1 list2)
        (if (null? list1)
            list2
            (helper (cdr list1) (cons (car list1) list2))
    )))
    (helper list '())
))

(reverse-v3 '(a b c d 5 4 3 2 1))