/*
   This prettyPrint() method takes a Tree
   and converts it into a well formated string.

   This pretty-printer does the following.
      1) It puts the left node "inline" with the root.
      2) It handles the special case when depth=1.
      3) It handles the special case when degree=1 and depth=2.
*/

public class PrettyPrinter3
{
   public static String prettyPrint(Tree tree)
   {
      return prettyPrint(tree, 0, true);
   }


   private static String prettyPrint(Tree tree, int indentation, boolean inline)
   {
      String indent = "";
      for (int i = 0; i < indentation; i++)
         indent += " ";

      String result = "";

      if (tree.degree() == 0)
      {
         result += tree.getElement();
      }
      else if ( tree.depth() == 1 )
      {
         result += "(" + tree.getElement();

         for (int i = 0; i < tree.degree(); i++)
            result += " " + tree.getSubTree(i).getElement();

         result += ")";
      }
      else if ( (tree.degree() == 1) && (tree.depth() == 2) )
      {
         result += "(" + tree.getElement() + " ";

         result += prettyPrint( tree.getSubTree(0), indentation, true );

         result += ")";
      }
      else
      {
         result += "(" + tree.getElement() + " ";

         indentation += 2 + tree.getElement().length();
         result += prettyPrint( tree.getSubTree(0), indentation, true ) + "\n";
         for (int i = 1; i < tree.degree(); i++)
            result += prettyPrint( tree.getSubTree(i), indentation, false ) + "\n";

         result += indent + ")";
      }

      if ( ! inline )
         result = indent + result;

      return result;
   }

}//PrettyPrinter3