/**

*/

public class Value
{
   public String tag;    // either "int", "bool", "closure", "builtin", "list", "sym"
   public int valueI=0;
   public boolean valueB=false;
   public IPEP valueC=null;
   public String valueBi=null;
   public ConsCell valueL=null;
   public String valueS=null;

   /**
      Construct a Value object that holds an int value.
   */
   public Value(String tag, int value)
   {
      if (tag.equals("int"))
      {
         this.tag = tag;
         valueI = value;
      }
      else
         throw new Error("invalid value tag: " + tag);
   }

   /**
      Construct a Value object that holds a boolean value.
   */
   public Value(String tag, boolean value)
   {
      if (tag.equals("bool"))
      {
         this.tag = tag;
         valueB = value;
      }
      else
         throw new Error("invalid value tag: " + tag);
   }

   /**
      Construct a Value object that holds a closure value.
   */
   public Value(String tag, IPEP value)
   {
      if (tag.equals("closure"))
      {
         this.tag = tag;
         valueC = value;
      }
      else
         throw new Error("invalid value tag: " + tag);
   }

   /**
      Construct a Value object that holds a builtin or a symbol value.
   */
   public Value(String tag, String value)
   {
      if (tag.equals("builtin"))
      {
         this.tag = tag;
         valueBi = value;
      }
      else if (tag.equals("sym"))
      {
         this.tag = tag;
         valueS = value;
      }
      else
         throw new Error("invalid value tag: " + tag);
   }

   /**
      Construct a Value object that holds a list value.
   */
   public Value(String tag, ConsCell value)
   {
      if (tag.equals("list"))
      {
         this.tag = tag;
         valueL = value;
      }
      else
         throw new Error("invalid value tag: " + tag);
   }

   /**
      Construct a Value object that holds an empty list value.
   */
   public Value(String tag)
   {
      if (tag.equals("list"))
      {
         this.tag = tag;
         valueL = null;
      }
      else
         throw new Error("cannot create an empty value of type " + tag);
   }

/*
   public String toString()
   {
      return "[tag->" + tag + ", valueI->" + valueI + ", valueB->" + valueB + ", valueC->" + valueC + ", valueBi->" + valueBi + ", valueL->" + valueL + ", valueS->" + valueS + "]";
   }
*/

   public String toString()
   {
      String result = "";

      if ( tag.equals("bool") )
      {
         result += valueB;
      }
      else if ( tag.equals("int") )
      {
         result += valueI;
      }
      else if ( tag.equals("closure") )
      {
         result += valueC;
      }
      else if ( tag.equals("builtin") )
      {
         result += valueBi;
      }
      else if ( tag.equals("list") )
      {
         result += "[" + valueL + " ]";
      }
      else if ( tag.equals("sym") )
      {
         result += valueS;
      }
      else  // bad tag (shouldn't get here)
      {
         result += "[tag->" + tag + ", valueI->" + valueI + ", valueB->" + valueB + ", valueC->" + valueC + ", valueBi->" + valueBi + ", valueL->" + valueL + ", valueS->" + valueS + "]";
      }

      return result;
   }

}//Value