/**
   A Tree is defined by the following grammar.

     Tree ::= '(' String Tree+ ')'
            | String

   where '(' and ')' are literals, and Tree+ means "one or more".

   This language also assumes that all tokens have white space around them.

   The static method getTree() is essentially a recursive descent
   parser for this Tree langauge.

   Notice that this version of BuildTree has a lot more error checking.
*/

public class BuildTree
{
   public static Tree buildTree(String expression) throws ParseException
   {
      Tokenizer tokens = new Tokenizer(expression);  // Tokenizer is defined
                                                     // in Tokenizer.java
      Tree result = getTree(tokens); // parse the tokens

      if ( tokens.hasToken() )  // there shouldn't be any more tokens
         throw new ParseException("unexpected input: "+tokens.peekToken()+"\n"+tokens + "\n");

      return result;
   }//buildTree()


   private static Tree getTree(Tokenizer tokens) throws ParseException
   {
      Tree result;

      if ( ! tokens.hasToken() )  // there should be another token
         throw new ParseException("unexpected end of input: " + "\n" + tokens + "\n");
      String token = tokens.nextToken(); // consume one token

      if ( token.equals("(") )           // look for a parenthesized tree
      {
         if ( ! tokens.hasToken() )  // there should be another token
            throw new ParseException("unexpected end of input: " + "\n" + tokens + "\n");
         result = new Tree( tokens.nextToken() ); // consume the root of the tree

         result.addSubTree( getTree(tokens) );    // consume first sub tree

         if ( ! tokens.hasToken() )  // there should be another token
            throw new ParseException("unexpected end of input: " + "\n" + tokens + "\n");
         token = tokens.peekToken();              // one character look ahead

         while ( ! token.equals(")") )
         {
            result.addSubTree( getTree(tokens) ); // consume the sub tree
            if ( ! tokens.hasToken() )  // there should be another token
               throw new ParseException("unexpected end of input: " + "\n" + tokens + "\n");
            token = tokens.peekToken();           // one character look ahead
         }
         tokens.match(")");   // consume the matching ")"
      }
      else
      {
         result = new Tree(token); // the tree must be just the root
      }
      return result;
   }//getTree()

}//BuildTree