/*
   This program parses and then evaluates strings from Language_2.
*/

public class Language_2_Examples
{
   public static void main(String[] args)
   {
      String[] exprs = {
                         "( + 1 2 ) )",        // invalid expression
                         "( + 1 2 ",           // invalid expression
                         "( + 1 (+ 2 3)) ",    // invalid expression
                         "( + 1 ( + 2 3 ] ) ", // invalid expression
                         "( - 1 2 3 )",        // invalid expression
                         "( * 3 )",            // invalid expression
                         "( ! true false )",   // invalid expression
                         "x",                  // invalid expression
                         "( @ 2 3 )",          // invalid expression
                         "( + 2 false )",      // invalid expression
                         "( ! 2 )",            // invalid expression
                         "( + 2 ( * 5 5 2 ) )",
                         "( + ( * 5 5 2 ) 2 )",
                         "( - ( * ( + 3 3 2 ) 4 ) 9 )",
                         "( - 9 ( * 4 ( + 3 2 3 ) ) )",
                         "( + ( / ( * 32 41 ) 2 ) ( * 12 48 ) )",
                         "( ! false )",
                         "( || true false )",
                         "( ! ( && true false ) )",
                         "( < 3 5 )",
                         "( && ( < 3 5 ) ( ! ( > 3 0 ) ) )",
                         "( == ( + 4 2 ) ( * 2 3 ) )",
                         "( == ( > 4 2 ) ( < 2 3 ) )",
                         "( + 2 ( * 5 5 ) ( / 4 2 ) )",
                         "( + ( - 10 ) ( + 10 ) )",
                         "( * ( + 2 3 ) ( + 4 5 ) ( + 5 7 ) )",
                         "( && ( ! ( > 1 2 ) ) ( == ( - ( - 2 4 ) ) 2 ) )",
                         "( || true ( != ( / 1 0 ) 0 ) )",
                         "( && ( == ( - 1 1 ) 0 ) ( < ( - 1 ) 1 ) false ( == 0 ( / 1 0 ) ) )",
                         "( + 1 ( ^ 2 1 ) ( ^ 2 2 ) ( ^ 2 3 ) ( ^ 2 4 ) ( ^ 2 5 ) ( ^ 2 6 ) )"
                       };

      int i = 0;
      for (i = 0; i < exprs.length; i++)
      {
         System.out.println(i + " =============================================");

         // Print the expression.
         //System.out.println( exprs[i] + "\n" );

         // Build the abstract syntax tree that represents the expression.
         try
         {
            Tree ast = BuildTree.buildTree( exprs[i] );

            // Print the AST as an S-expression
            System.out.println( ast + "\n" );

            // Pretty-print the abstract syntax tree.
            System.out.println( PrettyPrinter.prettyPrint( ast ) + "\n" );

            // Print the infix version of the expression.
            System.out.println( AST2infix.ast2infix( ast ) + "\n" );

            // Evaluate the expression (interpret the AST).
            try
            {
               Value result = Evaluate.eval( ast );
               System.out.println( "result = " + result + "\n" );
            }
            catch (EvalException e)
            {
               System.out.println(e);
             //e.printStackTrace();
            }


            // Create dot and png files from the ast.
            if(true)
            try
            {
               // Create the (empty) dot file.
               String baseName = String.format("Language_2.%02d", i);
               java.io.PrintWriter out = new java.io.PrintWriter(
                                            new java.io.File(baseName + ".dot"));
               // Put dot commands into the dot file
               out.println( Tree2dot_ver1.tree2dot(ast) + "\n" );
               out.close();

               // Create a command line for running dot.exe.
               String[] cmd = {"dot.exe",
                               "-Tpng",
                               baseName + ".dot",
                               "-o",
                               baseName + ".png"};
               // Execute the command line.
               java.lang.Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e)
            {
               System.out.println( e );
            }
         }
         catch (ParseException e)
         {
            System.out.println(e);
          //e.printStackTrace();
         }
      }
   }//main()

}//Language_2_Examples