/*
   This program parses and evaluates strings from Language_4.
*/

public class Language_4_Examples
{
   public static void main(String[] args)
   {
      String[] programs =
      {
        "( prog " +
          "( begin ( var x 2 ) " +
                  "( var y 2 ) ) " +
          "( var z ( + x y ) ) )",

         "( prog " +
           "( var x 0 ) " +
           "( var y 0 ) " +
           "( begin ( var x 2 ) " +
                   "( var y 2 ) ) " +
                   "( var x ( + x y 3 ) ) )",

         "( prog " +
           "( var x 4 ) " +
           "( begin ( var y false ) " +
                   "( || y ( == ( + 2 x ) ( * 2 3 ) ) ) ) )",

         "( prog " +
           "( var x1 1 ) " +
           "( var x1 ( + x1 1 ) ) " +
           "( begin " +
             "( var x1 ( + x1 1 ) ) " +
             "( var x1 ( + x1 1 ) ) " +
             "( var x2 ( + x1 1 ) ) ) " +
           "( var x1 ( + x1 1 ) ) " +
           "( var x2 ( + x1 1 ) ) )",

         "( prog " +
           "( var x 1 ) " +
           "( begin " +
             "( print x ) " +
             "( var x 2 ) " +
             "( begin " +
               "( print x ) " +
               "( var x 3 ) " +
               "( print x ) " +
               "( var x 4 ) ) " +
             "( print x ) " +
             "( var x 5 ) ) " +
           "( print x ) )",

         "( prog " +
           "( var n 1 ) " +
           "( var x1 ( * n n ) ) " +
           "( var n 2 ) " +
           "( var x2 ( * n n ) ) " +
           "( var n 3 ) " +
           "( var x3 ( * n n ) ) " +
           "( var n 4 ) " +
           "( var x4 ( * n n ) ) " +
           "( + ( + ( + x1 x2 ) x3 ) x4 ) )"
      };

      int i = 0;
      for (i = 0; i < programs.length; i++)
      {
         System.out.println(i + " =============================================");

         // Print the expression.
         //System.out.println( programs[i] + "\n" );

         // Build the abstract syntax tree that represents the expression.
         try
         {
            Tree ast = BuildTree.buildTree( programs[i] );

            // Print the AST as an S-expression
            System.out.println( ast + "\n" );

            // Pretty-print the abstract syntax tree.
            System.out.println( PrettyPrinter.prettyPrint( ast ) + "\n" );

            // Print the infix version of the expression.
            System.out.println( AST2infix.ast2infix( ast ) + "\n" );

            // Evaluate the expression (interpret the AST).
            try
            {
               Value value = Evaluate.eval( ast );
               System.out.println( "result = " + value + "\n" );
            }
            catch (EvalException e)
            {
               System.out.println(e);
             //e.printStackTrace();
            }


            // Create dot and png files from the AST.
            if(true)
            try
            {
               // Create the (empty) dot file.
               String baseName = String.format("Language_4.%02d", i);
               java.io.PrintWriter out = new java.io.PrintWriter(
                                            new java.io.File(baseName + ".dot") );
               // Put dot commands into the dot file
               out.println( Tree2dot_ver1.tree2dot(ast) + "\n" );
               out.close();
               // Create a command line for running dot.exe.
               String[] cmd = {"dot.exe",
                               "-Tpng",
                               baseName + ".dot",
                               "-o",
                               baseName + ".png"};
               // Execute the command line.
               java.lang.Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e)
            {
               System.out.println( e );
            }
         }
         catch (ParseException e)
         {
            System.out.println(e);
          //e.printStackTrace();
         }
      }
   }//main()

}//Language_4_Examples