
import java.util.List;

/**
   This define a generic BinaryTree abstract data type.

   Here is a summary of the methods in this class.
      E data()
      BinaryTree<E> left()
      BinaryTree<E> right()
      boolean isEmpty()
      int size()
      List<E> preOrder()
      List<E> inOrder()
      List<E> postOrder()
      String toString()
*/
public abstract class BinaryTree<E>
{
   /**
      Return the data element stored at the root of this BinaryTree.

      @return the root data element of this BinaryTree
      @throws IllegalStateException if this BinaryTree is empty
   */
   public abstract E data();


   /**
      Return the left binary sub tree.

      @return the left sub tree of this BinaryTree
      @throws IllegalStateException if this BinaryTree is empty
   */
   public abstract BinaryTree<E> left();


   /**
      Return the right binary sub tree.

      @return the right sub tree of this BinaryTree
      @throws IllegalStateException if this BinaryTree is empty
   */
   public abstract BinaryTree<E> right();


   /**
      Return true if this BinaryTree does not
      contain any nodes.

      @return true if this BinaryTree is empty
   */
   public abstract boolean isEmpty();


   /**
      Return the number of nodes in this BinaryTree.

      @return the number of nodes in this BinaryTree
   */
   public abstract int size();


   /**
      Do a pre-order traversal of this BinaryTree.

      @return a List of the pre-order traversal of this BinaryTree
   */
   public abstract List<E> preOrder();


   /**
      Do an in-order traversal of this BinaryTree.

      @return a List of the in-order traversal of this BinaryTree
   */
   public abstract List<E> inOrder();


   /**
      Do a post-order traversal of this BinaryTree.

      @return a List of the post-order traversal of this BinaryTree
   */
   public abstract List<E> postOrder();


   @Override
   public String toString()
   {
      return isEmpty() ? "()" :
               (left().isEmpty() && right().isEmpty())? "" + data() :
                 "(" + data() + ", " + left() + ", " + right() + ")";
   }
}
