/**
   The prettyPrint() method takes a Tree and
   converts it into a well formatted string.
*/

public class PrettyPrinter
{
   public static String prettyPrint(Tree tree)
   {
      return prettyPrint(tree, "");
   }

   /**
      This prettyPrint() method is essentially
      a pre-order traversal of the tree.
   */
   private static String prettyPrint(Tree tree, String indentation)
   {
      String result = "";

      if ( 0 == tree.degree() )  // what if this used tree.depth()?
      {
         result += indentation + tree.getElement();
      }
      else
      {
         // "process" the root node
         result += indentation + "(" + tree.getElement() + "\n";

         // recursively traverse all the sub trees
         for (int i = 0; i < tree.degree(); i++)
         {
            result += prettyPrint( tree.getSubTree(i), indentation+"  " ) + "\n";
         }

         result += indentation + ")";
      }

      return result;
   }//prettyPrint()
}//PrettyPrinter
