/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Language_0 {
    public static void main(String[] args) throws IOException {
        if (args.length > 1) {
            System.out.println("Usage: Language_0 <script>");
        } else if (args.length == 1) {
            Language_0.runFile(args[0]);
        } else {
            Language_0.runPrompt();
        }
    }

    private static void runFile(String path) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(path, new String[0]));
        String source = new String(bytes, Charset.defaultCharset());
        try {
            Tokenizer tokens = new Tokenizer(source);
            System.out.println(tokens);
            Tree tree = ParseTree.buildTree(tokens);
            System.out.println(tree + "\n");
            System.out.println(PrettyPrinter.prettyPrint(tree) + "\n");
            try {
                String baseName = path;
                PrintWriter out = new PrintWriter(new File(baseName + ".dot"));
                out.println(Tree2dot_ver1.tree2dot(tree) + "\n");
                out.close();
                String[] cmd = new String[]{"C:\\graphviz-2.38\\release\\bin\\dot.exe", "-Tpng", baseName + ".dot", "-o", baseName + ".png"};
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        catch (TokenizeException e) {
            System.out.println(e);
        }
        catch (ParseException e) {
            System.out.println(e);
        }
    }

    private static void runPrompt() throws IOException {
        InputStreamReader input = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(input);
        System.out.println("Language 0.");
        int i = 1;
        while (true) {
            System.out.print("> ");
            String source = reader.readLine();
            try {
                Tokenizer tokens = new Tokenizer(source);
                if (tokens.hasToken()) {
                    Tree tree = ParseTree.buildTree(tokens);
                    if (tokens.hasToken()) {
                        throw new ParseException("unexpected input: " + tokens.peekToken().lexeme + " at line " + tokens.peekToken().line + ", position " + tokens.peekToken().position + "\n");
                    }
                    System.out.println(PrettyPrinter.prettyPrint(tree) + "\n");
                    try {
                        String baseName = String.format("repl.%02d", i);
                        PrintWriter out = new PrintWriter(new File(baseName + ".dot"));
                        out.println(Tree2dot_ver1.tree2dot(tree) + "\n");
                        out.close();
                        String[] cmd = new String[]{"C:\\graphviz-2.38\\release\\bin\\dot.exe", "-Tpng", baseName + ".dot", "-o", baseName + ".png"};
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (IOException e) {
                        System.out.println(e);
                    }
                }
            }
            catch (TokenizeException e) {
                System.out.println(e);
            }
            catch (ParseException e) {
                System.out.println(e);
            }
            ++i;
        }
    }
}

