/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.PrintWriter;

public class Language_0_Example_3 {
    public static void main(String[] args) throws ParseException, TokenizeException {
        String[] treeStrings = new String[]{"(a b\n\nc\td e)", "(a (b c d) (e f g))", "(a (b c) d (e (f g h i j)))", "(* (+ x y) (- z))", "(/ x (+ y z u v))", "(define (fac n) (if (== n 0) 1 (* n (fac (- n 1)))))", "(while (<= n 100) (begin (print (* n n)) (== n (+ n 2))))"};
        for (int i = 0; i < treeStrings.length; ++i) {
            System.out.println(i + " =============================================");
            Tree tree = ParseTree.buildTree(treeStrings[i]);
            System.out.println("Tree expression = " + tree + "\n");
            System.out.println(PrettyPrinter.prettyPrint(tree) + "\n");
            try {
                String baseName = String.format("Example_3.%02d", i);
                PrintWriter out = new PrintWriter(new File(baseName + ".dot"));
                out.println(Tree2dot_ver1.tree2dot(tree) + "\n");
                out.close();
                String[] cmd = new String[]{"C:\\graphviz-2.38\\release\\bin\\dot.exe", "-Tpng", baseName + ".dot", "-o", baseName + ".png"};
                Runtime.getRuntime().exec(cmd);
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

