/*
 * Decompiled with CFR 0.152.
 */
public class ParseTree {
    public static Tree buildTree(String expression) throws ParseException, TokenizeException {
        Tokenizer tokens = new Tokenizer(expression);
        return ParseTree.buildTree(tokens);
    }

    public static Tree buildTree(Tokenizer tokens) throws ParseException {
        Tree result = ParseTree.getTree(tokens);
        if (tokens.hasToken()) {
            throw new ParseException("unexpected input: " + tokens.peekToken().lexeme + " at line " + tokens.peekToken().line + ", position " + tokens.peekToken().position + "\n");
        }
        return result;
    }

    private static Tree getTree(Tokenizer tokens) throws ParseException {
        Tree result;
        if (!tokens.hasToken()) {
            throw new ParseException("unexpected end of input: \n" + tokens + "\n");
        }
        Token token = tokens.nextToken();
        if (token.lexeme.equals("(")) {
            if (!tokens.hasToken()) {
                throw new ParseException("unexpected end of input: \n" + tokens + "\n");
            }
            result = new Tree(tokens.nextToken().lexeme, new Tree[0]);
            result.addSubTree(ParseTree.getTree(tokens));
            if (!tokens.hasToken()) {
                throw new ParseException("unexpected end of input: \n" + tokens + "\n");
            }
            token = tokens.peekToken();
            while (!token.lexeme.equals(")")) {
                result.addSubTree(ParseTree.getTree(tokens));
                if (!tokens.hasToken()) {
                    throw new ParseException("unexpected end of input: \n" + tokens + "\n");
                }
                token = tokens.peekToken();
            }
            tokens.match(")");
        } else {
            result = new Tree(token.lexeme, new Tree[0]);
        }
        return result;
    }
}

