/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

class Tokenizer {
    private final String source;
    private final List<Token> tokens = new ArrayList<Token>();
    private int currentToken;
    private int start = 0;
    private int current = 0;
    private int line = 1;
    private int startOfLine = this.current;

    public Tokenizer(String source) throws TokenizeException {
        this.source = source;
        this.scanTokens();
        this.currentToken = 0;
    }

    private void scanTokens() throws TokenizeException {
        while (!this.isAtEnd()) {
            this.start = this.current;
            this.scanToken();
        }
    }

    private void scanToken() throws TokenizeException {
        char c = this.advance();
        switch (c) {
            case '(': {
                this.addToken();
                break;
            }
            case ')': {
                this.addToken();
                break;
            }
            case ',': {
                this.addToken();
                break;
            }
            case ';': {
                this.addToken();
                break;
            }
            case '*': {
                this.addToken();
                break;
            }
            case '%': {
                this.addToken();
                break;
            }
            case '^': {
                this.addToken();
                break;
            }
            case '|': {
                this.match('|');
                this.addToken();
                break;
            }
            case '&': {
                this.match('&');
                this.addToken();
                break;
            }
            case '=': {
                this.match('=');
                this.addToken();
                break;
            }
            case '!': {
                this.match('=');
                this.addToken();
                break;
            }
            case '<': {
                this.match('=');
                this.addToken();
                break;
            }
            case '>': {
                this.match('=');
                this.addToken();
                break;
            }
            case '/': {
                if (this.match('/')) {
                    while (this.peek() != '\n' && !this.isAtEnd()) {
                        this.advance();
                    }
                    break;
                }
                this.addToken();
                break;
            }
            case '+': {
                if (this.isDigit(this.peek())) {
                    this.advance();
                    this.integer();
                    break;
                }
                this.match('+');
                this.addToken();
                break;
            }
            case '-': {
                if (this.isDigit(this.peek())) {
                    this.advance();
                    this.integer();
                    break;
                }
                this.match('-');
                this.addToken();
                break;
            }
            case '\t': 
            case '\r': 
            case ' ': {
                break;
            }
            case '\n': {
                ++this.line;
                this.startOfLine = this.current;
                break;
            }
            default: {
                if (this.isDigit(c)) {
                    this.integer();
                    break;
                }
                if (this.isAlpha(c)) {
                    this.variable();
                    break;
                }
                throw new TokenizeException("unexpected character: '" + c + "' at line " + this.line + ", position " + (this.start - this.startOfLine + 1) + "\n");
            }
        }
    }

    private void addToken() {
        String text = this.source.substring(this.start, this.current);
        this.tokens.add(new Token(text, this.line, this.start - this.startOfLine + 1));
    }

    private char advance() {
        ++this.current;
        return this.source.charAt(this.current - 1);
    }

    private boolean match(char expected) {
        if (this.isAtEnd()) {
            return false;
        }
        if (this.source.charAt(this.current) != expected) {
            return false;
        }
        ++this.current;
        return true;
    }

    private char peek() {
        if (this.isAtEnd()) {
            return '\u0000';
        }
        return this.source.charAt(this.current);
    }

    private char peekNext() {
        if (this.current + 1 >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.current + 1);
    }

    private boolean isAtEnd() {
        return this.current >= this.source.length();
    }

    private void variable() {
        while (this.isAlphaNumeric(this.peek())) {
            this.advance();
        }
        this.addToken();
    }

    private void integer() {
        while (this.isDigit(this.peek())) {
            this.advance();
        }
        this.addToken();
    }

    private boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isAlphaNumeric(char c) {
        return this.isAlpha(c) || this.isDigit(c);
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public Token nextToken() {
        return this.tokens.get(this.currentToken++);
    }

    public boolean match(String lexeme) {
        boolean match = lexeme.equals(this.tokens.get((int)this.currentToken).lexeme);
        if (match) {
            ++this.currentToken;
            return true;
        }
        return false;
    }

    public Token peekToken() {
        return this.tokens.get(this.currentToken);
    }

    public Token peek2Token() {
        return this.tokens.get(this.currentToken + 1);
    }

    public boolean hasToken() {
        return this.currentToken < this.tokens.size();
    }

    public String toString() {
        Object result = "";
        for (Token t : this.tokens) {
            result = (String)result + t + "\n";
        }
        return result;
    }
}

