/*
   This program demonstrates how difficult it is in
   languages like Java (or C or C++) to instantiate
   a complex data structure like a tree. Below is
   code that instantiates the following tree.

                a
              / | \
             /  |  \
            b   c    d
          /  \       |
         /    \      |
        e      f     g
                   / | \
                  /  |  \
                 h   i   j
                 |
                 |
                 k

   This program assumes that you have installed Graphviz, which includes
   the dot.exe program. You can download Graphviz and dot.exe from the
   following URL. Unzip the zip file to your C:\ drive.

     https://graphviz.gitlab.io/_pages/Download/windows/graphviz-2.38.zip
*/

public class Language_0_Example_1
{
   public static void main(String[] args)
   {
      Tree tree = null;

      // Here is how we can build a Tree data structure.
      tree = new Tree("a", new Tree("b", new Tree("e"), new Tree("f")), new Tree("c"), new Tree("d", new Tree("g", new Tree("h", new Tree("k")), new Tree("i"), new Tree("j"))));

       // Here is a clearer way to format the same code.
       // (Notice that this is formatted in a way analogous
       //  to the way the prettyprinter prints the tree.)
      tree = new Tree("a",
                      new Tree("b",
                               new Tree("e"),
                               new Tree("f")),
                      new Tree("c"),
                      new Tree("d",
                               new Tree("g",
                                        new Tree("h",
                                                 new Tree("k")),
                                        new Tree("i"),
                                        new Tree("j"))));


       // Here is a third way to format the same code.
      tree = new Tree("a", new Tree("b", new Tree("e"),
                                         new Tree("f")),
                           new Tree("c"),
                           new Tree("d", new Tree("g", new Tree("h", new Tree("k")),
                                                       new Tree("i"),
                                                       new Tree("j"))));

      // Print the Tree using its toString() method.
      System.out.println( "Tree expression = " + tree + "\n" );

      // The "pretty printer" prints out the tree in a nice format.
      System.out.println( PrettyPrinter.prettyPrint( tree ) + "\n" );

      // Let us traverse the tree so that we can convince
      // ourselves that it was constructed correctly.
      // We should get "a b e f c d g h k i j".
      System.out.println( " Pre-order traversal = " + Traverse.preOrder(  tree ) + "\n" );
      // We should get "e f b c k h i j g d a".
      System.out.println( "Post-order traversal = " + Traverse.postOrder( tree ) + "\n" );


      // Create dot and png files from the tree.
      if(true)  // "conditional complilation" the java way
      try
      {
         // Create the (empty) dot file.
         String baseName = "Example_1";
         java.io.PrintWriter out = new java.io.PrintWriter(
                                      new java.io.File(baseName + ".dot"));
         // Put dot commands into the dot file
         out.println( Tree2dot_ver1.tree2dot(tree) + "\n" );
         out.close();

         // Create a command line for running dot.exe.
         String[] cmd = {"C:\\graphviz-2.38\\release\\bin\\dot.exe",
                         "-Tpng",
                         baseName + ".dot",
                         "-o",
                         baseName + ".png"};
         // Execute the command line.
         java.lang.Runtime.getRuntime().exec(cmd);
      }
      catch (Exception e)
      {
         System.out.println( e );
      }
   }
}
