/*
   This program builds some more trees using our tree language.

   This program assumes that you have installed Graphviz, which includes
   the dot.exe program. You can download Graphviz and dot.exe from the
   following URL. Unzip the zip file to your C:\ drive.

     https://graphviz.gitlab.io/_pages/Download/windows/graphviz-2.38.zip
*/

public class Language_0_Example_3
{
   public static void main(String[] args) throws ParseException, TokenizeException
   {
      String[] treeStrings = {"(a b\n\nc\td e)", // this string tests the tokenizer
                              "(a (b c d) (e f g))",
                              "(a (b c) d (e (f g h i j)))",
                              "(* (+ x y) (- z))",
                              "(/ x (+ y z u v))",
                              "(define (fac n) (if (== n 0) 1 (* n (fac (- n 1)))))",
                              "(while (<= n 100) (begin (print (* n n)) (== n (+ n 2))))"
                             };

      for (int i = 0; i < treeStrings.length; i++)
      {
         System.out.println(i + " =============================================");

         // Build the Tree data structure from its string representation.
         Tree tree = ParseTree.buildTree( treeStrings[i] );

         // Print the Tree using its toString() method.
         System.out.println( "Tree expression = " + tree + "\n" );

         // Pretty print the Tree in a nice format.
         System.out.println( PrettyPrinter.prettyPrint( tree ) + "\n" );

         // Create dot and png files from the tree.
         if(true)
         try
         {
            // Create the (empty) dot file.
            String baseName = String.format("Example_3.%02d", i);
            java.io.PrintWriter out = new java.io.PrintWriter(
                                         new java.io.File(baseName + ".dot"));
            // Put dot commands into the dot file
            out.println( Tree2dot_ver1.tree2dot(tree) + "\n" );
            out.close();

            // Create a command line for running dot.exe.
            String[] cmd = {"C:\\graphviz-2.38\\release\\bin\\dot.exe",
                            "-Tpng",
                            baseName + ".dot",
                            "-o",
                            baseName + ".png"};
            // Execute the command line.
            java.lang.Runtime.getRuntime().exec(cmd);
         }
         catch (Exception e)
         {
            System.out.println( e );
         }
      }
   }
}
