/**
   The preOrder() method prints out an pre-order
   traversal of the nodes of a Tree.

   The postOrder() method prints out an post-order
   traversal of the nodes of a Tree.
*/

public class Traverse
{
   public static String preOrder(Tree tree)
   {
      String result = "";

      // "process" the root node
      result += tree.getElement() + " ";

      // recursively traverse all the sub trees
      for (int i = 0; i < tree.degree(); i++)
         result += preOrder( tree.getSubTree(i) );

      return result;
   }


   public static String postOrder(Tree tree)
   {
      String result = "";

      // recursively traverse all the sub trees
      for (int i = 0; i < tree.degree(); i++)
         result += postOrder( tree.getSubTree(i) );

      // "process" the root node
      result += tree.getElement() + " ";

      return result;
   }
}
