/**
   This program converts a Tree data structure into
   a DOT description of the tree. The DOT description
   can then be processed by the dot.exe command to
   produce a graphical image of the tree data struncture.

   Create a png file (from a dot file) with the following
   command line.
   > dot.exe -Tpng -O tree.dot

   See
   http://www.graphviz.org/Documentation.php
*/

public class Tree2dot_ver1
{
   private static int nodeCount;

   public static String tree2dot(Tree tree)
   {
      String result = "graph {\n";
      nodeCount = 0;
      result += tree2dot(tree, nodeCount);
      result += "}\n";
      return result;
   }


   /**
      This tree2dot() method is essentially a
      preorder traversal of the tree.
   */
   public static String tree2dot(Tree tree, int nodeNumber)
   {
      String result = "";

      // "process" the root node
      result += "node" + nodeNumber + "[label=\"" + tree.getElement() + "\"];\n";

      // recursively traverse all the sub trees
      for (int i = 0; i < tree.degree(); i++)
      {
         // create an edge
         result += "node" + nodeNumber + " -- " + "node" + (++nodeCount) + ";\n";
         // convert the sub tree into a dot description
         result += tree2dot(tree.getSubTree(i), nodeCount);
      }

      return result;
   }
}
