/*
 * Decompiled with CFR 0.152.
 */
public class AST2infix {
    public static String ast2infix(Tree tree) {
        return AST2infix.convertProg(tree, "", true);
    }

    public static String convertProg(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        if (!tree.getElement().equals("prog")) {
            result = (String)result + AST2infix.convertExp(tree, "", false);
        } else {
            result = (String)result + "Program\n{\n";
            for (int i = 0; i < tree.degree(); ++i) {
                result = (String)result + AST2infix.convertExp(tree.getSubTree(i), "   ", false);
                if (tree.getSubTree(i).getElement().equals("fun")) {
                    result = (String)result + "\n";
                }
                result = tree.getSubTree(i).getElement().equals("fun") || tree.getSubTree(i).getElement().equals("begin") || tree.getSubTree(i).getElement().equals("if") || tree.getSubTree(i).getElement().equals("while") || tree.getSubTree(i).getElement().equals("for") ? (String)result + "\n" : (String)result + ";\n";
            }
            result = (String)result + "}";
        }
        return result;
    }

    public static String convertExp(Tree tree, String indent, boolean inline) {
        Object result = "";
        String node = tree.getElement();
        result = node.equals("fun") ? (String)result + AST2infix.convertFun(tree, indent, inline) : (node.equals("lambda") ? (String)result + AST2infix.convertLambda(tree, indent, inline) : (node.equals("apply") ? (String)result + AST2infix.convertApply(tree, indent, inline) : (node.equals("if") ? (String)result + AST2infix.convertIf(tree, indent, inline) : (node.equals("while") ? (String)result + AST2infix.convertWhile(tree, indent, inline) : (node.equals("set") ? (String)result + AST2infix.convertSet(tree, indent, inline) : (node.equals("var") ? (String)result + AST2infix.convertVar(tree, indent, inline) : (node.equals("begin") ? (String)result + AST2infix.convertBegin(tree, indent, inline) : (node.equals("print") ? (String)result + AST2infix.convertPrint(tree, indent, inline) : (node.equals("&&") || node.equals("||") || node.equals("!") || node.equals("<") || node.equals(">") || node.equals("<=") || node.equals(">=") || node.equals("==") || node.equals("!=") || node.equals("+") || node.equals("-") || node.equals("*") || node.equals("/") || node.equals("%") || node.equals("^") ? (String)result + AST2infix.convertBRAexp(tree, indent, inline) : (tree.degree() == 0 ? (String)result + (String)(inline ? node : indent + node) : (String)result + (inline ? tree : indent + tree)))))))))));
        return result;
    }

    public static String convertFun(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        result = (String)result + tree.getSubTree(0).getElement() + "(";
        int numberOfParameters = tree.getSubTree(1).degree() - 1;
        for (int i = 0; i < numberOfParameters; ++i) {
            String variable = tree.getSubTree(1).getSubTree(i).getElement();
            result = (String)result + variable;
            if (i >= numberOfParameters - 1) continue;
            result = (String)result + ", ";
        }
        result = (String)result + ")\n";
        if (tree.getSubTree(1).getSubTree(numberOfParameters).getElement().equals("begin")) {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1).getSubTree(numberOfParameters), indent, false);
        } else {
            result = (String)result + indent + "{\n";
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1).getSubTree(numberOfParameters), indent + "   ", false);
            result = tree.getSubTree(1).getSubTree(numberOfParameters).getElement().equals("fun") || tree.getSubTree(1).getSubTree(numberOfParameters).getElement().equals("while") || tree.getSubTree(1).getSubTree(numberOfParameters).getElement().equals("if") || tree.getSubTree(1).getSubTree(numberOfParameters).getElement().equals("for") ? (String)result + "\n" + indent + "}" : (String)result + ";\n" + indent + "}";
        }
        return result;
    }

    public static String convertLambda(Tree tree, String indent, boolean inline) {
        int numberOfParameters;
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        if (0 == (numberOfParameters = tree.degree() - 1)) {
            result = (String)result + "()";
        } else if (1 == numberOfParameters) {
            result = (String)result + tree.getSubTree(0).getElement();
        } else {
            result = (String)result + "(";
            result = (String)result + tree.getSubTree(0).getElement();
            for (int i = 1; i < numberOfParameters; ++i) {
                String variable = tree.getSubTree(i).getElement();
                result = (String)result + ", " + variable;
            }
            result = (String)result + ")";
        }
        result = (String)result + " -> ";
        result = (String)result + AST2infix.convertExp(tree.getSubTree(numberOfParameters), indent, true);
        return result;
    }

    public static String convertApply(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        if (tree.getSubTree(0).degree() > 0) {
            result = (String)result + "(";
        }
        result = (String)result + AST2infix.convertExp(tree.getSubTree(0), indent, true);
        if (tree.getSubTree(0).degree() > 0) {
            result = (String)result + ")";
        }
        result = (String)result + "(";
        for (int i = 1; i < tree.degree(); ++i) {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(i), indent, true);
            if (i >= tree.degree() - 1) continue;
            result = (String)result + ", ";
        }
        result = (String)result + ")";
        return result;
    }

    public static String convertIf(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        result = (String)result + "if (" + AST2infix.convertExp(tree.getSubTree(0), indent + "       ", true) + ")\n";
        if (tree.getSubTree(1).getElement().equals("begin")) {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1), indent, false);
        } else if (tree.getSubTree(1).getElement().equals("fun") || tree.getSubTree(1).getElement().equals("while") || tree.getSubTree(1).getElement().equals("if") || tree.getSubTree(1).getElement().equals("for")) {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1), indent + "   ", false);
        } else {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1), indent + "   ", false);
            result = (String)result + ";";
        }
        result = (String)result + "\n" + indent + "else\n";
        result = tree.getSubTree(2).getElement().equals("begin") ? (String)result + AST2infix.convertExp(tree.getSubTree(2), indent, false) : (tree.getSubTree(2).getElement().equals("fun") || tree.getSubTree(2).getElement().equals("while") || tree.getSubTree(2).getElement().equals("if") || tree.getSubTree(2).getElement().equals("for") ? (String)result + AST2infix.convertExp(tree.getSubTree(2), indent + "   ", false) : (String)result + AST2infix.convertExp(tree.getSubTree(2), indent + "   ", false) + ";");
        return result;
    }

    public static String convertWhile(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        result = (String)result + "while (" + AST2infix.convertExp(tree.getSubTree(0), indent + "       ", true) + ")\n";
        if (tree.getSubTree(1).getElement().equals("begin")) {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1), indent, false);
        } else if (tree.getSubTree(1).getElement().equals("fun") || tree.getSubTree(1).getElement().equals("while") || tree.getSubTree(1).getElement().equals("if") || tree.getSubTree(1).getElement().equals("for")) {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1), indent + "   ", false);
        } else {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(1), indent + "   ", false);
            result = (String)result + ";";
        }
        return result;
    }

    public static String convertSet(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        result = (String)result + AST2infix.convertExp(tree.getSubTree(0), indent, true);
        result = (String)result + " = ";
        result = (String)result + AST2infix.convertExp(tree.getSubTree(1), "   " + indent, true);
        return result;
    }

    public static String convertVar(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        result = (String)result + "var " + AST2infix.convertExp(tree.getSubTree(0), indent, true);
        result = (String)result + " = ";
        result = (String)result + AST2infix.convertExp(tree.getSubTree(1), "     " + indent, true);
        return result;
    }

    public static String convertBegin(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        result = (String)result + "{\n";
        for (int i = 0; i < tree.degree(); ++i) {
            result = (String)result + AST2infix.convertExp(tree.getSubTree(i), indent + "   ", false);
            result = tree.getSubTree(i).getElement().equals("begin") || tree.getSubTree(i).getElement().equals("fun") || tree.getSubTree(i).getElement().equals("while") || tree.getSubTree(i).getElement().equals("if") || tree.getSubTree(i).getElement().equals("for") ? (String)result + "\n" : (String)result + ";\n";
        }
        result = (String)result + indent + "}";
        return result;
    }

    public static String convertPrint(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        result = (String)result + "print(" + AST2infix.convertExp(tree.getSubTree(0), indent, true) + ")";
        return result;
    }

    public static String convertBRAexp(Tree tree, String indent, boolean inline) {
        Object result = "";
        if (!inline) {
            result = (String)result + indent;
        }
        if (tree.degree() == 1) {
            result = tree.getSubTree(0).degree() >= 2 ? (String)result + tree.getElement() + "(" + AST2infix.convertExp(tree.getSubTree(0), indent, true) + ")" : (String)result + tree.getElement() + AST2infix.convertExp(tree.getSubTree(0), indent, true);
        } else if (tree.degree() == 2) {
            int middlePrecedence = AST2infix.precedence(tree.getElement());
            int leftPrecedence = AST2infix.precedence(tree.getSubTree(0).getElement());
            result = leftPrecedence > middlePrecedence ? (String)result + "(" + AST2infix.convertExp(tree.getSubTree(0), indent, true) + ")" : (String)result + AST2infix.convertExp(tree.getSubTree(0), indent, true);
            result = (String)result + " " + tree.getElement() + " ";
            int rightPrecedence = AST2infix.precedence(tree.getSubTree(1).getElement());
            result = rightPrecedence >= middlePrecedence ? (String)result + "(" + AST2infix.convertExp(tree.getSubTree(1), indent, true) + ")" : (String)result + AST2infix.convertExp(tree.getSubTree(1), indent, true);
        } else {
            int operatorPrecedence = AST2infix.precedence(tree.getElement());
            int leftPrecedence = AST2infix.precedence(tree.getSubTree(0).getElement());
            result = leftPrecedence > operatorPrecedence ? (String)result + "(" + AST2infix.convertExp(tree.getSubTree(0), indent, true) + ")" : (String)result + AST2infix.convertExp(tree.getSubTree(0), indent, true);
            for (int i = 1; i < tree.degree(); ++i) {
                result = (String)result + " " + tree.getElement() + " ";
                int rightPrecedence = AST2infix.precedence(tree.getSubTree(i).getElement());
                result = rightPrecedence >= operatorPrecedence ? (String)result + "(" + AST2infix.convertExp(tree.getSubTree(i), indent, true) + ")" : (String)result + AST2infix.convertExp(tree.getSubTree(i), indent, true);
            }
        }
        return result;
    }

    private static int precedence(String op) {
        int result = 0;
        if (op.equals("++") || op.equals("--")) {
            result = 1;
        } else if (op.equals("index")) {
            result = 1;
        } else if (op.equals("apply")) {
            result = 1;
        } else if (op.equals("rand")) {
            result = 1;
        } else if (op.equals("print")) {
            result = 1;
        } else if (op.equals("!") || op.equals("+++") || op.equals("---")) {
            result = 2;
        } else if (op.equals("^")) {
            result = 3;
        } else if (op.equals("*") || op.equals("/") || op.equals("%")) {
            result = 4;
        } else if (op.equals("+") || op.equals("-")) {
            result = 5;
        } else if (op.equals("<") || op.equals(">") || op.equals("<=") || op.equals(">=")) {
            result = 7;
        } else if (op.equals("==") || op.equals("!=")) {
            result = 8;
        } else if (op.equals("&&")) {
            result = 12;
        } else if (op.equals("||")) {
            result = 13;
        } else if (op.equals("set")) {
            result = 15;
        } else if (op.equals("var")) {
            result = 15;
        } else if (op.equals("for")) {
            result = 16;
        } else if (op.equals("if")) {
            result = 16;
        } else if (op.equals("while")) {
            result = 16;
        } else if (op.equals("begin")) {
            result = 16;
        }
        return result;
    }
}

