/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class Environment {
    private final ArrayList<String> variables = new ArrayList();
    private final ArrayList<Value> values = new ArrayList();
    private final Environment nonLocalLink;
    private final String label;

    public Environment() {
        this.nonLocalLink = null;
        this.label = "Global";
    }

    public Environment(Environment env, String label) {
        this.nonLocalLink = env;
        this.label = label;
    }

    public void add(String variable, Value value) {
        this.variables.add(variable);
        this.values.add(value);
    }

    public boolean defined(String variable) {
        return null != this.lookUp(variable);
    }

    public Value lookUp(String variable) {
        int i;
        for (i = 0; i < this.variables.size() && !variable.equals(this.variables.get(i)); ++i) {
        }
        if (i < this.variables.size()) {
            return this.values.get(i);
        }
        if (null == this.nonLocalLink) {
            return null;
        }
        return this.nonLocalLink.lookUp(variable);
    }

    public boolean definedLocal(String variable) {
        int i;
        for (i = 0; i < this.variables.size() && !variable.equals(this.variables.get(i)); ++i) {
        }
        return i < this.variables.size();
    }

    public boolean update(String variable, Value value) {
        int i;
        for (i = 0; i < this.variables.size() && !variable.equals(this.variables.get(i)); ++i) {
        }
        if (i < this.variables.size()) {
            this.values.set(i, value);
            return true;
        }
        if (null == this.nonLocalLink) {
            return false;
        }
        return this.nonLocalLink.update(variable, value);
    }

    public String toString() {
        Object result = "";
        result = null != this.nonLocalLink ? this.nonLocalLink.toString() + "\n/\\\n||\n[" + this.label + " Environment" : (String)result + "[" + this.label + " Environment";
        for (int i = 0; i < this.variables.size(); ++i) {
            result = (String)result + "\n[ " + this.variables.get(i) + " = " + this.values.get(i);
        }
        return result;
    }
}

