/*
 * Decompiled with CFR 0.152.
 */
public class Evaluate {
    public static int DEBUG = 1;

    public static Value eval(Tree tree) throws EvalException {
        Environment env = new Environment();
        return Evaluate.evaluateProg(tree, env);
    }

    public static Value evaluateProg(Tree tree, Environment env) throws EvalException {
        Value result;
        if (!tree.getElement().equals("prog")) {
            result = Evaluate.evaluateExp(tree, env);
        } else {
            for (int i = 0; i < tree.degree() - 1; ++i) {
                Evaluate.evaluateExp(tree.getSubTree(i), env);
            }
            result = Evaluate.evaluateExp(tree.getSubTree(tree.degree() - 1), env);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Value evaluateExp(Tree tree, Environment env) throws EvalException {
        String node = tree.getElement();
        if (node.equals("fun")) {
            return Evaluate.evaluateFun(tree, env);
        }
        if (node.equals("lambda")) {
            return Evaluate.evaluateLambda(tree, env);
        }
        if (node.equals("apply")) {
            return Evaluate.evaluateApply(tree, env);
        }
        if (node.equals("if")) {
            return Evaluate.evaluateIf(tree, env);
        }
        if (node.equals("while")) {
            return Evaluate.evaluateWhile(tree, env);
        }
        if (node.equals("begin")) {
            return Evaluate.evaluateBegin(tree, env);
        }
        if (node.equals("var")) {
            return Evaluate.evaluateVar(tree, env);
        }
        if (node.equals("set")) {
            return Evaluate.evaluateSet(tree, env);
        }
        if (node.equals("print")) {
            return Evaluate.evaluatePrint(tree, env);
        }
        if (node.equals("&&")) return Evaluate.evaluateBexp(tree, env);
        if (node.equals("||")) return Evaluate.evaluateBexp(tree, env);
        if (node.equals("!")) {
            return Evaluate.evaluateBexp(tree, env);
        }
        if (node.equals("==")) return Evaluate.evaluateEqexp(tree, env);
        if (node.equals("!=")) {
            return Evaluate.evaluateEqexp(tree, env);
        }
        if (node.equals("<")) return Evaluate.evaluateRelexp(tree, env);
        if (node.equals(">")) return Evaluate.evaluateRelexp(tree, env);
        if (node.equals("<=")) return Evaluate.evaluateRelexp(tree, env);
        if (node.equals(">=")) {
            return Evaluate.evaluateRelexp(tree, env);
        }
        if (node.equals("+")) return Evaluate.evaluateAexp(tree, env);
        if (node.equals("-")) return Evaluate.evaluateAexp(tree, env);
        if (node.equals("*")) return Evaluate.evaluateAexp(tree, env);
        if (node.equals("/")) return Evaluate.evaluateAexp(tree, env);
        if (node.equals("%")) return Evaluate.evaluateAexp(tree, env);
        if (node.equals("^")) {
            return Evaluate.evaluateAexp(tree, env);
        }
        if (tree.degree() != 0) throw new EvalException("invalid expression: " + tree);
        if (node.equals("true")) return new Value(node.equals("true"));
        if (node.equals("false")) {
            return new Value(node.equals("true"));
        }
        if (node.matches("^[-|+]*[0-9][0-9]*")) {
            return new Value(Integer.parseInt(node));
        }
        if (!env.defined(node)) throw new EvalException("undefined variable: " + node);
        return env.lookUp(node);
    }

    public static Value evaluateFun(Tree tree, Environment env) throws EvalException {
        String name = tree.getSubTree(0).getElement();
        if (!name.matches("^[a-zA-Z][a-zA-Z0-9]*")) {
            throw new EvalException("improper function name: " + name);
        }
        if (env.definedLocal(name)) {
            throw new EvalException("function already exists: " + name);
        }
        if (!tree.getSubTree(1).getElement().equals("lambda")) {
            throw new EvalException("bad function definition: " + tree);
        }
        Value ipep = Evaluate.evaluateLambda(tree.getSubTree(1), env);
        env.add(name, ipep);
        if (DEBUG > 0) {
            System.out.println(env + "\n");
        }
        return ipep;
    }

    public static Value evaluateLambda(Tree tree, Environment env) throws EvalException {
        return new Value(new IPEP(tree, env));
    }

    private static Value evaluateApply(Tree tree, Environment env) throws EvalException {
        Value funValue = Evaluate.evaluateExp(tree.getSubTree(0), env);
        if (!funValue.tag.equals("lambda")) {
            throw new EvalException("bad function value: " + tree);
        }
        IPEP ipep = funValue.valueL;
        Tree lambda = ipep.ip;
        Environment ep = ipep.ep;
        if (tree.degree() != lambda.degree()) {
            throw new EvalException("wrong number of arguments: " + tree);
        }
        Environment localEnv = new Environment(ep, "Function (" + ipep + ") Activation");
        for (int i = 1; i < tree.degree(); ++i) {
            Value actualParamValue = Evaluate.evaluateExp(tree.getSubTree(i), env);
            String formalParamName = lambda.getSubTree(i - 1).getElement();
            if (!formalParamName.matches("^[a-zA-Z][a-zA-Z0-9]*")) {
                throw new EvalException("improper parameter name: " + formalParamName);
            }
            localEnv.add(formalParamName, actualParamValue);
        }
        if (DEBUG > 0) {
            System.out.println(localEnv + "\n");
        }
        Value result = Evaluate.evaluateExp(lambda.getSubTree(tree.degree() - 1), localEnv);
        return result;
    }

    private static Value evaluateIf(Tree tree, Environment env) throws EvalException {
        if (3 != tree.degree()) {
            throw new EvalException("incorrect conditional expression: " + tree);
        }
        Value conditionalExp = Evaluate.evaluateExp(tree.getSubTree(0), env);
        if (!conditionalExp.tag.equals("bool")) {
            throw new EvalException("illegal boolean expression: " + tree);
        }
        Value result = conditionalExp.valueB ? Evaluate.evaluateExp(tree.getSubTree(1), env) : Evaluate.evaluateExp(tree.getSubTree(2), env);
        return result;
    }

    private static Value evaluateWhile(Tree tree, Environment env) throws EvalException {
        if (2 != tree.degree()) {
            throw new EvalException("incorrect while expression: " + tree);
        }
        Value conditionalExp = Evaluate.evaluateExp(tree.getSubTree(0), env);
        if (!conditionalExp.tag.equals("bool")) {
            throw new EvalException("illegal boolean expression: " + tree);
        }
        while (conditionalExp.valueB) {
            Evaluate.evaluateExp(tree.getSubTree(1), env);
            conditionalExp = Evaluate.evaluateExp(tree.getSubTree(0), env);
            if (conditionalExp.tag.equals("bool")) continue;
            throw new EvalException("illegal boolean expression: " + tree);
        }
        return new Value(false);
    }

    private static Value evaluateBegin(Tree tree, Environment env) throws EvalException {
        Environment newEnv = new Environment(env, "Local (begin)");
        for (int i = 0; i < tree.degree() - 1; ++i) {
            Evaluate.evaluateExp(tree.getSubTree(i), newEnv);
        }
        Value result = Evaluate.evaluateExp(tree.getSubTree(tree.degree() - 1), newEnv);
        return result;
    }

    private static Value evaluateVar(Tree tree, Environment env) throws EvalException {
        if (2 != tree.degree()) {
            throw new EvalException("wrong number of arguments: " + tree);
        }
        String variable = tree.getSubTree(0).getElement();
        if (!variable.matches("^[a-zA-Z][a-zA-Z0-9]*")) {
            throw new EvalException("improper variable name: " + variable);
        }
        if (env.definedLocal(variable)) {
            throw new EvalException("variable already declared: " + variable);
        }
        Tree expr = tree.getSubTree(1);
        Value result = Evaluate.evaluateExp(expr, env);
        env.add(variable, result);
        if (DEBUG > 0) {
            System.out.println(env + "\n");
        }
        return result;
    }

    private static Value evaluateSet(Tree tree, Environment env) throws EvalException {
        if (2 != tree.degree()) {
            throw new EvalException("wrong number of arguments: " + tree);
        }
        String variable = tree.getSubTree(0).getElement();
        if (!variable.matches("^[a-zA-Z][a-zA-Z0-9]*")) {
            throw new EvalException("improper variable name: " + variable);
        }
        if (!env.defined(variable)) {
            throw new EvalException("undefined variable: " + variable);
        }
        Tree expr = tree.getSubTree(1);
        Value result = Evaluate.evaluateExp(expr, env);
        env.update(variable, result);
        if (DEBUG > 0) {
            System.out.println(env + "\n");
        }
        return result;
    }

    private static Value evaluatePrint(Tree tree, Environment env) throws EvalException {
        if (1 != tree.degree()) {
            throw new EvalException("wrong number of arguments: " + tree);
        }
        Value result = Evaluate.evaluateExp(tree.getSubTree(0), env);
        if (DEBUG > 0) {
            System.out.println(result);
        } else {
            System.out.println(result.toSimpleString());
        }
        return result;
    }

    private static Value evaluateBexp(Tree tree, Environment env) throws EvalException {
        boolean result = false;
        String node = tree.getElement();
        Value value = Evaluate.evaluateExp(tree.getSubTree(0), env);
        if (!value.tag.equals("bool")) {
            throw new EvalException("not a boolean expression: " + tree.getSubTree(0));
        }
        result = value.valueB;
        if (node.equals("&&")) {
            if (2 > tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            for (int i = 1; i < tree.degree(); ++i) {
                if (!result) {
                    result = false;
                    break;
                }
                value = Evaluate.evaluateExp(tree.getSubTree(i), env);
                if (!value.tag.equals("bool")) {
                    throw new EvalException("not a boolean expression: " + tree.getSubTree(i));
                }
                result = result && value.valueB;
            }
        } else if (node.equals("||")) {
            if (2 > tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            for (int i = 1; i < tree.degree(); ++i) {
                if (result) {
                    result = true;
                    break;
                }
                value = Evaluate.evaluateExp(tree.getSubTree(i), env);
                if (!value.tag.equals("bool")) {
                    throw new EvalException("not a boolean expression: " + tree.getSubTree(i));
                }
                result = result || value.valueB;
            }
        } else if (node.equals("!")) {
            if (1 != tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            result = !result;
        }
        return new Value(result);
    }

    private static Value evaluateEqexp(Tree tree, Environment env) throws EvalException {
        int resultR;
        int resultL;
        if (2 != tree.degree()) {
            throw new EvalException("wrong number of arguments: " + tree);
        }
        String op = tree.getElement();
        Value valueL = Evaluate.evaluateExp(tree.getSubTree(0), env);
        Value valueR = Evaluate.evaluateExp(tree.getSubTree(1), env);
        boolean result = op.equals("==") ? (!valueL.tag.equals(valueR.tag) ? false : (valueL.tag.equals("int") ? (resultL = valueL.valueI) == (resultR = valueR.valueI) : (resultL = valueL.valueB) == (resultR = valueR.valueB))) : (!valueL.tag.equals(valueR.tag) ? true : (valueL.tag.equals("int") ? (resultL = valueL.valueI) != (resultR = valueR.valueI) : (resultL = valueL.valueB) != (resultR = valueR.valueB)));
        return new Value(result);
    }

    private static Value evaluateRelexp(Tree tree, Environment env) throws EvalException {
        if (2 != tree.degree()) {
            throw new EvalException("wrong number of arguments: " + tree);
        }
        String op = tree.getElement();
        Value valueL = Evaluate.evaluateExp(tree.getSubTree(0), env);
        if (!valueL.tag.equals("int")) {
            throw new EvalException("not a integer expression: " + tree.getSubTree(0));
        }
        Value valueR = Evaluate.evaluateExp(tree.getSubTree(1), env);
        if (!valueR.tag.equals("int")) {
            throw new EvalException("not a integer expression: " + tree.getSubTree(1));
        }
        int resultL = valueL.valueI;
        int resultR = valueR.valueI;
        boolean result = op.equals("<") ? resultL < resultR : (op.equals(">") ? resultL > resultR : (op.equals("<=") ? resultL <= resultR : resultL >= resultR));
        return new Value(result);
    }

    private static Value evaluateAexp(Tree tree, Environment env) throws EvalException {
        int result = 0;
        String node = tree.getElement();
        Value valueL = Evaluate.evaluateExp(tree.getSubTree(0), env);
        if (!valueL.tag.equals("int")) {
            throw new EvalException("not a integer expression: " + tree.getSubTree(0));
        }
        int resultL = valueL.valueI;
        int resultR = 0;
        Value valueR = null;
        if (tree.degree() >= 2) {
            valueR = Evaluate.evaluateExp(tree.getSubTree(1), env);
            if (!valueR.tag.equals("int")) {
                throw new EvalException("not a integer expression: " + tree.getSubTree(1));
            }
            resultR = valueR.valueI;
        }
        if (node.equals("+")) {
            if (tree.degree() == 1) {
                result = resultL;
            } else {
                result = resultL + resultR;
                for (int i = 2; i < tree.degree(); ++i) {
                    Value temp = Evaluate.evaluateExp(tree.getSubTree(i), env);
                    if (!temp.tag.equals("int")) {
                        throw new EvalException("not a integer expression: " + tree.getSubTree(i));
                    }
                    result += temp.valueI;
                }
            }
        } else if (node.equals("-")) {
            if (2 < tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            result = tree.degree() == 1 ? -resultL : resultL - resultR;
        } else if (node.equals("*")) {
            if (1 == tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            result = resultL * resultR;
            for (int i = 2; i < tree.degree(); ++i) {
                Value temp = Evaluate.evaluateExp(tree.getSubTree(i), env);
                if (!temp.tag.equals("int")) {
                    throw new EvalException("not a integer expression: " + tree.getSubTree(i));
                }
                result *= temp.valueI;
            }
        } else if (node.equals("/")) {
            if (2 != tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            result = resultL / resultR;
        } else if (node.equals("%")) {
            if (2 != tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            result = resultL % resultR;
        } else if (node.equals("^")) {
            if (2 != tree.degree()) {
                throw new EvalException("wrong number of arguments: " + tree);
            }
            result = (int)Math.pow(resultL, resultR);
        }
        return new Value(result);
    }
}

