/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Language_8 {
    public static void main(String[] args) throws IOException {
        Evaluate.DEBUG = 1;
        if (args.length > 1) {
            System.out.println("Usage: Language_8 <script>");
        } else if (args.length == 1) {
            Language_8.runFile(args[0]);
        } else {
            Language_8.runPrompt();
        }
    }

    private static void runFile(String path) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(path, new String[0]));
        String source = new String(bytes, Charset.defaultCharset());
        try {
            Tokenizer tokens = new Tokenizer(source);
            Tree ast = ParseTree.buildTree(tokens);
            System.out.println(AST2infix.ast2infix(ast) + "\n");
            if (Evaluate.DEBUG > 0) {
                try {
                    String baseName = path;
                    PrintWriter out = new PrintWriter(new File(baseName + ".dot"));
                    out.println(Tree2dot.tree2dot(ast) + "\n");
                    out.close();
                    String[] cmd = new String[]{"C:\\graphviz-2.38\\release\\bin\\dot.exe", "-Tpng", baseName + ".dot", "-o", baseName + ".png"};
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
            Value value = Evaluate.eval(ast);
            if (Evaluate.DEBUG > 0) {
                System.out.println("result = " + value);
            } else {
                System.out.println("result = " + value.toSimpleString());
            }
        }
        catch (TokenizeException e) {
            System.out.println(e);
        }
        catch (ParseException e) {
            System.out.println(e);
        }
        catch (EvalException e) {
            System.out.println(e);
        }
    }

    private static void runPrompt() throws IOException {
        InputStreamReader input = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(input);
        Environment globalEnv = new Environment();
        System.out.println("Language 8.");
        int i = 1;
        while (true) {
            block11: {
                System.out.print("> ");
                String source = reader.readLine();
                try {
                    Tokenizer tokens = new Tokenizer(source);
                    if (!tokens.hasToken()) break block11;
                    Tree ast = ParseTree.buildTree(tokens);
                    if (tokens.hasToken()) {
                        throw new ParseException("unexpected input: " + tokens.peekToken().lexeme + " at line " + tokens.peekToken().line + ", position " + tokens.peekToken().position);
                    }
                    if (Evaluate.DEBUG > 0) {
                        try {
                            String baseName = String.format("repl.%02d", i);
                            PrintWriter out = new PrintWriter(new File(baseName + ".dot"));
                            out.println(Tree2dot.tree2dot(ast) + "\n");
                            out.close();
                            String[] cmd = new String[]{"C:\\graphviz-2.38\\release\\bin\\dot.exe", "-Tpng", baseName + ".dot", "-o", baseName + ".png"};
                            Runtime.getRuntime().exec(cmd);
                        }
                        catch (IOException e) {
                            System.out.println(e);
                        }
                    }
                    Value value = Evaluate.evaluateExp(ast, globalEnv);
                    if (Evaluate.DEBUG > 0) {
                        System.out.println("< " + value);
                    } else {
                        System.out.println("< " + value.toSimpleString());
                    }
                }
                catch (TokenizeException e) {
                    System.out.println(e);
                }
                catch (ParseException e) {
                    System.out.println(e);
                }
                catch (EvalException e) {
                    System.out.println(e);
                }
            }
            ++i;
        }
    }
}

