/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class Tree {
    private String element;
    private ArrayList<Tree> subTrees;

    public Tree(String element, Tree ... subTrees) {
        this.element = element;
        if (0 != subTrees.length) {
            this.subTrees = new ArrayList();
            for (Tree tree : subTrees) {
                this.subTrees.add(tree);
            }
        }
    }

    public String getElement() {
        return this.element;
    }

    public void addSubTree(Tree tree) {
        if (this.subTrees == null) {
            this.subTrees = new ArrayList();
        }
        this.subTrees.add(tree);
    }

    public Tree getSubTree(int i) {
        return this.subTrees.get(i);
    }

    public int degree() {
        if (this.subTrees == null) {
            return 0;
        }
        return this.subTrees.size();
    }

    public int depth() {
        int result = 0;
        if (this.degree() > 0) {
            int max = 0;
            for (int i = 0; i < this.degree(); ++i) {
                int temp = this.getSubTree(i).depth();
                if (temp <= max) continue;
                max = temp;
            }
            result = 1 + max;
        }
        return result;
    }

    public String toString() {
        Object result = "";
        if (null == this.subTrees) {
            result = (String)result + this.element;
        } else {
            result = (String)result + "(" + this.element;
            for (int i = 0; i < this.subTrees.size(); ++i) {
                result = (String)result + " " + this.subTrees.get(i);
            }
            result = (String)result + ")";
        }
        return result;
    }
}

