/**
   This class implements "closure" objects.

   The ip reference points to a block of code (usually
   a function body) that may make references to non-local
   variables (so the block of code has "free variables").

   The ep reference points to an Environment object that
   "closes" the block of code by providing values for the
   non-local references made by the block of code.
*/

public class IPEP
{
   public Tree ip;        // the ip, the "instruction pointer"
   public Environment ep; // the ep, the "environment pointer"

   /**
      Construct a IPEP object
   */
   public IPEP(Tree tree, Environment env)
   {
      this.ip = tree;
      this.ep = env;
   }
}
