/*
   This program parses and evaluates strings from Language_8.
*/

public class Language_8_Examples
{
   public static void main(String[] args)
   {
      // IMPORTANT: Set this to 0 or 1 depending on whether you need
      // to see all of the interpreter's debugging information.
      Evaluate.DEBUG = 1;

      final String[] programs =
      {
         "(apply (lambda x (* x x)) 7)", // apply an anonymous lambda expression

         "(prog" +
           "(fun g (lambda h (apply h 5)))" +
           "(apply g (lambda x (* x x))))", // pass an anonymous lambda as a parameter

         "(prog" +
           "(var g (lambda h (apply h 5)))" + // define g using var instead of fun
           "(apply g (lambda x (* x x))))",

         // apply an anonymous function (with a function parameter) to an anonymous function
         "(apply (lambda h (apply h 7)) (lambda x (+ x x x)))",

         // anonymous functions as return values
         "(prog" +
           "(fun h (lambda b (if b (lambda x (* x x))" +       // anonymous lambda
                                  "(lambda x (* x x x)))))" +  // anonymous lambda
           "(var r1 (apply (apply h  true) 5)) " +             // returns 25
           "(print r1)" +
           "(var r2 (apply (apply h false) 5)))",              // returns 125

         // another anonymous function as a return value.
         // (With dynamic scope, this program would return a different result.)
         "(prog" +
           "(var x -100)" +
           "(fun f (lambda x (lambda y (+ y x))))" +
           "(apply (apply f 5) 100))",

         // Demonstrate a nested anonymous function parameter.
         // The final result should be 321.
         // (It would be 421 using dynamic scope.)
         "(prog" +
           "(var w 300)" +
           "(fun f1 (lambda x (apply f2 (lambda y (+ (+ x y) w)))))" +
           "(fun f2 (lambda z (begin" +                 // z is a function parameter
                                    "(var w 400)" +
                                    "(apply z 20))))" + // call the function parameter
           "(apply f1 1))"
      };


      for (int i = 0; i < programs.length; ++i)
      {
         System.out.println(i + " =========================================");

         // Build and evaluate the AST that represents the expression.
         try
         {
            final Tree ast = ParseTree.buildTree( programs[i] );

            // Print the AST as an S-expression
            //System.out.println( ast + "\n" );

            // Pretty-print the abstract syntax tree.
            //System.out.println( PrettyPrinter.prettyPrint( ast ) + "\n" );

            // Print the infix version of the expression.
            System.out.println( AST2infix.ast2infix( ast ) + "\n" );

            // Evaluate the expression (interpret the AST).
            try
            {
               final Value value = Evaluate.eval( ast );
               if (Evaluate.DEBUG > 0)
               {
                  System.out.println("result = " + value + "\n" );
               }
               else
               {
                  System.out.println("result = " + value.toSimpleString() + "\n" );
               }
            }
            catch (EvalException e)
            {
               System.out.println(e);
             //e.printStackTrace();
            }


            // Create dot and png files from the AST.
            if (Evaluate.DEBUG > 0)
            try
            {
               // Create the (empty) dot file.
               final String baseName = String.format("Language_8.%02d", i);
               java.io.PrintWriter out = new java.io.PrintWriter(
                                            new java.io.File(baseName + ".dot") );
               // Put dot commands into the dot file
               out.println( Tree2dot.tree2dot(ast) + "\n" );
               out.close();
               // Create a command line for running dot.exe.
               final String[] cmd = {"C:\\graphviz-2.38\\release\\bin\\dot.exe",
                                     "-Tpng",
                                     baseName + ".dot",
                                     "-o",
                                     baseName + ".png"};
               // Execute the command line.
               java.lang.Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e)
            {
               System.out.println( e );
            }
         }
         catch (TokenizeException e)
         {
            System.out.println(e);
          //e.printStackTrace();
         }
         catch (ParseException e)
         {
            System.out.println(e);
          //e.printStackTrace();
         }
      }
   }
}
