// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Closures
function makeAdder(x) {
  return function(y) {
    return x + y;
  };
}

var add5 = makeAdder(5);
var add10 = makeAdder(10);

var r1 = add5(2);  // 7
var r2 = add10(2); // 12

console.dir(add5); // in DevTools this will show the closure
console.dir(add10);
