// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Closures
function makeCounter(x) {
  return function() {
    return ++x;
  };
}

var countFrom5 = makeCounter(5);
var countFrom10 = makeCounter(10);

var r1 = countFrom5();  // 6
var r2 = countFrom5();  // 7
var r3 = countFrom5();  // 8
var r4 = countFrom10(); // 11
var r5 = countFrom10(); // 12
var r6 = countFrom5();  // 9

console.dir(countFrom5); // in DevTools this will show the closure
console.dir(countFrom10);
