/**
   A graphics example.
*/
import java.awt.*;
import javax.swing.*;

public class GraphicsExperiment4
{
   public static void main( String[] args )
   {
      JFrame f = new JFrame();
      f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      f.setTitle("A frame with a graphics panel");
      f.setSize(500, 500);
      f.setVisible(true);

      JPanel panel = new GraphicsPanel();
      f.getContentPane().setLayout(new FlowLayout());
      f.add(panel);
      f.add(new JButton("hello"));
      System.out.println("bye");
   }
}


@SuppressWarnings("serial")
class GraphicsPanel extends JPanel
{
   int count = 0;

   public GraphicsPanel()
   {
      setPreferredSize(new Dimension(400, 400));
      setBackground(Color.WHITE);
   }

   @Override
   public void paintComponent(Graphics g)
   {
      super.paintComponent(g);  // call JPanel's version
      g.setColor(Color.red);
      g.fillRect(20, 40, 70, 30);
      g.setColor(Color.blue);
      g.fillRect(60, 10, 20, 80);
      g.setColor(Color.green);
      g.fillRect(300, 300, 100, 100);
      g.setColor(Color.black);
      g.drawLine(0,0, 300,300);
      System.out.println(count++);
   }
}
