/*
   Count the number of bytes in all the files in the current directory.

   This version memory maps each file using MappedByteBuffer
   and the map() method in FileChannel.
*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
//import java.nio.MappedByteBuffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.Path;

public class CountBytesMemoryMappedFiles
{
   private static long totalByteCounter = 0;

   public static void main(String[] args) throws IOException
   {
      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Count bytes in all Memory Mapped Files");
      Instant start = Instant.now();

      Files.list(Paths.get("."))
             .filter(p -> p.toString().endsWith(".txt"))
               .forEach(p -> countInFile(p)); // files are processed sequentially

      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s %,d bytes read from all files.\n",
                        ft.format(new Date()), totalByteCounter);
      System.out.printf("elapsed time: %,dms\n", time);
  }



   public static void countInFile(Path path)
   {
      try
      {
         String fileName = path.getFileName().toString();
       //FileChannel fc = new FileInputStream(fileName).getChannel();
         FileChannel fc = new RandomAccessFile(fileName, "r").getChannel();
         long fileSize = fc.size(); // assume that each file is < 2GB
         ByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0, fileSize);

         long byteCounter = 0;

         int i = 4096;
         for (; i < fileSize; i += 4096) // jump through virtual memory pages
         {
            mbb.get(i); // touch page and cause a page fault (try commenting this out!)
            byteCounter += 4096L;
         }
         byteCounter += 4096L - (i - fileSize); // count the last partial page

         totalByteCounter += byteCounter;
       //System.out.println(byteCounter);
         mbb = null;  // make sure to garbage collect the MappedByteBuffer
      }
      catch(IOException e){throw new Error(e);}
   }
}
