/*



*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;
import java.io.FileReader;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.Path;

public class CountBytes_v3_Files
{
   private static final int BUFFERSIZE = 16 * 8192; // changing this doesn't seem to matter
   private static long totalByteCounter = 0;

   public static void main(String[] args) throws IOException
   {
      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Count bytes in all Files ver 3");
      Instant start = Instant.now();

      Files.list(Paths.get("."))
             .parallel() // doesn't seem to do anything
               .filter(p -> p.toString().endsWith(".txt"))
                 .forEach(p -> countInFile(p)); // files are processed sequentially

      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s %,d bytes read from all files.\n",
                        ft.format(new Date()), totalByteCounter);
      System.out.printf("elapsed time: %,dms\n", time);
   }


   public static void countInFile(Path path)
   {
      long byteCounter = 0;

      try
      {
         final String fileName = path.getFileName().toString();
         final BufferedReader br = new BufferedReader(new FileReader(fileName), BUFFERSIZE);

         String oneLine = null;

         while ( (oneLine = br.readLine()) != null )
         {
            byteCounter += 1 + oneLine.length();
         }

         totalByteCounter += byteCounter;
       //System.out.println(byteCounter);
         br.close();
      }
      catch(IOException e){throw new Error(e);}
   }
}
