/*



*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.Path;

public class CountBytes_v4_Files
{
   private static final int BUFFERSIZE = 16 * 8192;
   private static long totalByteCounter = 0;

   public static void main(String[] args) throws IOException
   {
      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Count bytes in all Files ver 4");
      Instant start = Instant.now();

      Files.list(Paths.get("."))
             .parallel() // doesn't seem to do anything
               .filter(p -> p.toString().endsWith(".txt"))
                 .forEach(p -> countInFile(p)); // files are processed sequentially

      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s %,d bytes read from all files.\n",
                        ft.format(new Date()), totalByteCounter);
      System.out.printf("elapsed time: %,dms\n", time);
   }


   public static void countInFile(Path path)
   {
      byte[] c = new byte[BUFFERSIZE];
      int n;
      long byteCounter = 0;

      try
      {
         final String fileName = path.getFileName().toString();
         final InputStream is = new FileInputStream(fileName);

         while ( (n = is.read(c)) != -1 ) // read one buffer full at a time
         {
            byteCounter += n;
         }

         totalByteCounter += byteCounter;
       //System.out.println(byteCounter);
         is.close();
      }
      catch(IOException e){throw new Error(e);}
   }
}
