/*



*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.Path;

public class CountLines_v4_Files
{
   private static final int BUFFERSIZE = 16 * 8192;
   private static long totalByteCounter = 0;
   private static long totalLineCounter = 0;
   private static long crCounter = 0;      // check for ascii CR characters
   private static long eofCounter = 0;     // check for ascii eof characters
   private static long ctrlCounter = 0;    // check for ascii control characters
   private static long binaryCounter = 0;  // check for non-ascii binary bytes

   public static void main(String[] args) throws IOException
   {
      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Count lines in all Files ver 4");
      Instant start = Instant.now();

      Files.list(Paths.get("."))
             .filter(p -> p.toString().endsWith(".txt"))
               .forEach(p -> countInFile(p)); // files are processed sequentially

      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s %,d bytes read from all files.\n",
                        ft.format(new Date()), totalByteCounter);
      System.out.printf("%s %,d lines read from all files.\n",
                        ft.format(new Date()), totalLineCounter);
      System.out.printf("%s %,d carriage returns read from all files.\n",
                        ft.format(new Date()), crCounter);
      System.out.printf("%s %,d eof characters read from all files.\n",
                        ft.format(new Date()), eofCounter);
      System.out.printf("%s %,d ascii control characters read from all files.\n",
                        ft.format(new Date()), ctrlCounter);
      System.out.printf("%s %,d non-ascii bytes read from all files.\n",
                        ft.format(new Date()), binaryCounter);
      System.out.printf("elapsed time: %,dms\n", time);
   }


   public static void countInFile(Path path)
   {
      byte[] c = new byte[BUFFERSIZE];
      int n;
      long byteCounter = 0;
      long lineCounter = 1;

      try
      {
         final String fileName = path.getFileName().toString();
         final InputStream is = new FileInputStream(fileName);

         while ( (n = is.read(c)) != -1 )
         {
            byteCounter += n;
            for (int i = 0; i < n; ++i)
            {
               if ( '\n' == c[i] )
               {
                  ++lineCounter;
               }
               else if ( 0x0D == c[i] )
               {
                  ++crCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
               else if ( 0x0C == c[i] ) // 0x09 and 0x0C
               {
                  ++eofCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
               else if ( 0x1F >= c[i] )
               {
                  ++ctrlCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
               else if ( 0x80 <= c[i] )
               {
                  ++binaryCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
            }
         }

         totalByteCounter += byteCounter;
         totalLineCounter += lineCounter;
         is.close();
      }
      catch(IOException e){throw new Error(e);}
   }
}
