/*



*/

import java.io.*;
//import java.nio.MappedByteBuffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.*;

public class Count_BytesMemoryMappedFiles
{
   private static long totalByteCounter = 0;

   public static void main(String[] args) throws IOException
   {
      Files.list(Paths.get("."))
             .filter(p -> p.toString().endsWith(".txt"))
               .forEach(p -> countInFile(p)); // files are processed sequentially

      System.out.printf("%,d bytes read from all files\n", totalByteCounter);
  }



   public static void countInFile(Path path)
   {
      try
      {
         String fileName = path.getFileName().toString();
       //FileChannel fc = new FileInputStream(fileName).getChannel();
         FileChannel fc = new RandomAccessFile(fileName, "r").getChannel();
         long fileSize = fc.size(); // assume that each file is < 2GB
         ByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0, fileSize);

         long byteCounter = 0;

         int i = 4096;
         for (; i < fileSize; i += 4096) // jump through virtual memory pages
         {
            mbb.get(i); // touch page and cause a page fault (try commenting this out!)
            byteCounter += 4096L;
         }
         byteCounter += 4096L - (i - fileSize); // count the last partial page

         totalByteCounter += byteCounter;
         mbb = null;  // make sure to garbage collect the MappedByteBuffer
      }
      catch(IOException e){throw new Error(e);}
   }
}
