/*



*/

import java.io.*;
import java.nio.file.*;

public class Count_Bytes_v2_Files
{
   //private static final int BUFFERSIZE = 16 * 8192;
   private static long totalByteCounter = 0;

   public static void main(String[] args) throws IOException
   {
      Files.list(Paths.get("."))
             .parallel() // doesn't seem to do anything
               .filter(p -> p.toString().endsWith(".txt"))
                 .forEach(p -> countInFile(p));

      System.out.printf("%,d bytes read from all files\n", totalByteCounter);
   }


   public static void countInFile(Path path)
   {
      long byteCounter = 0;

      try
      {
         final String fileName = path.getFileName().toString();
         final InputStream is = new BufferedInputStream(
                                      new FileInputStream(fileName));

         while ( is.read() != -1 ) // read one byte at a time
         {
            ++byteCounter;
         }

         totalByteCounter += byteCounter;
         is.close();
      }
      catch(IOException e){throw new Error(e);}
   }
}
