/*



*/

import java.io.*;
import java.nio.file.*;

public class Count_Bytes_v3_Files
{
   private static final int BUFFERSIZE = 16 * 8192; // changing this doesn't seem to matter
   private static long totalByteCounter = 0;

   public static void main(String[] args) throws IOException
   {
      Files.list(Paths.get("."))
             .parallel() // doesn't seem to do anything
               .filter(p -> p.toString().endsWith(".txt"))
                 .forEach(p -> countInFile(p));

      System.out.printf("%,d bytes read from all files\n", totalByteCounter);
   }


   public static void countInFile(Path path)
   {
      long byteCounter = 0;

      try
      {
         final String fileName = path.getFileName().toString();
         final BufferedReader br = new BufferedReader(new FileReader(fileName), BUFFERSIZE);

         String oneLine = null;

         while ( (oneLine = br.readLine()) != null )
         {
            byteCounter += 1 + oneLine.length();
         }

         totalByteCounter += byteCounter;
         br.close();
      }
      catch(IOException e){throw new Error(e);}
   }
}
