/*



*/

import java.io.*;
//import java.nio.MappedByteBuffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.*;

public class Count_LinesMemoryMappedFiles
{
   private static long totalByteCounter = 0;
   private static long totalLineCounter = 0;

   public static void main(String[] args) throws IOException
   {
      Files.list(Paths.get("."))
             .filter(p -> p.toString().endsWith(".txt"))
               .forEach(p -> countInFile(p));

      System.out.printf("%,d bytes read from all files\n", totalByteCounter);
      System.out.printf("%,d lines read from all files\n", totalLineCounter);
  }



   public static void countInFile(Path path)
   {
      try
      {
         String fileName = path.getFileName().toString();
       //FileChannel fc = new FileInputStream(fileName).getChannel();
         FileChannel fc = new RandomAccessFile(fileName, "r").getChannel();
         long fileSize = fc.size(); // assume that each file is < 2GB
         ByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0, fileSize);

         long byteCounter = 0;
         long lineCounter = 1;

         for (int i = 0; i < fileSize; ++i)
         {
            ++byteCounter;
            if ( '\n' == mbb.get() )
            {
               ++lineCounter;
            }
         }

         totalByteCounter += byteCounter;
         totalLineCounter += lineCounter;
         mbb = null;  // make sure to garbage collect the MappedByteBuffer
      }
      catch(IOException e){throw new Error(e);}
   }
}
