/*



*/

import java.io.*;
import java.nio.file.*;

public class Count_Lines_v3_Files
{
   private static final int BUFFERSIZE = 16 * 8192;
   private static long totalByteCounter = 0;
   private static long totalLineCounter = 0;

   public static void main(String[] args) throws IOException
   {
      Files.list(Paths.get("."))
             .filter(p -> p.toString().endsWith(".txt"))
               .forEach(p -> countInFile(p));

      System.out.printf("%,d bytes read from all files\n", totalByteCounter);
      System.out.printf("%,d lines read from all files\n", totalLineCounter);
   }


   public static void countInFile(Path path)
   {
      long byteCounter = 0;
      long lineCounter = 0;

      try
      {
         final String fileName = path.getFileName().toString();
         final BufferedReader br = new BufferedReader(new FileReader(fileName), BUFFERSIZE);

         String oneLine = null;

         while ( (oneLine = br.readLine()) != null )
         {
            ++lineCounter;
            byteCounter += 1 + oneLine.length();
         }

         totalByteCounter += byteCounter;
         totalLineCounter += lineCounter;
         br.close();
      }
      catch(IOException e){throw new Error(e);}
   }
}
