/*



*/

import java.io.*;
import java.nio.file.*;

public class Count_Lines_v4_Files
{
   private static final int BUFFERSIZE = 16 * 8192;
   private static long totalByteCounter = 0;
   private static long totalLineCounter = 0;
   private static long crCounter = 0;      // check for ascii CR characters
   private static long eofCounter = 0;     // check for ascii eof characters
   private static long ctrlCounter = 0;    // check for ascii control characters
   private static long binaryCounter = 0;  // check for non-ascii binary bytes

   public static void main(String[] args) throws IOException
   {
      Files.list(Paths.get("."))
             .filter(p -> p.toString().endsWith(".txt"))
               .forEach(p -> countInFile(p));

      System.out.printf("%,d bytes read from all files\n", totalByteCounter);
      System.out.printf("%,d lines read from all files\n", totalLineCounter);
      System.out.printf("%,d carriage returns read from all files.\n", crCounter);
      System.out.printf("%,d eof characters read from all files.\n", eofCounter);
      System.out.printf("%,d ascii control characters read from all files\n", ctrlCounter);
      System.out.printf("%,d non-ascii bytes read from all files\n", binaryCounter);
   }


   public static void countInFile(Path path)
   {
      byte[] c = new byte[BUFFERSIZE];
      int n;
      long byteCounter = 0;
      long lineCounter = 1;

      try
      {
         final String fileName = path.getFileName().toString();
         final InputStream is = new FileInputStream(fileName);

         while ( (n = is.read(c)) != -1 )
         {
            byteCounter += n;
            for (int i = 0; i < n; ++i)
            {
               if ( '\n' == c[i] )
               {
                  ++lineCounter;
               }
               else if ( 0x0D == c[i] )
               {
                  ++crCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
               else if ( 0x0C == c[i] ) // 0x09 and 0x0C
               {
                  ++eofCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
               else if ( 0x1F >= c[i] )
               {
                  ++ctrlCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
               else if ( 0x80 <= c[i] )
               {
                  ++binaryCounter;
                  //System.out.printf("%s, line %,d\n", fileName, lineCounter);
               }
            }
         }

         totalByteCounter += byteCounter;
         totalLineCounter += lineCounter;
         is.close();
      }
      catch(IOException e){throw new Error(e);}
   }
}
