/*
   Sequential search for "aardvark" in one file called "data".

   This version memory maps the data file using MappedByteBuffer
   and the map() method in FileChannel.

   The data file is larger than the 2GB mapping limit, so we need
   to map the file in two segments. We may lose an "aardvark" match
   if it just happens to straddle the 2GB position in the file. This
   isn't too hard to fix.
*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
//import java.nio.MappedByteBuffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class SearchSequentialMemoryMappedFile
{
   public static void main(String[] args) throws IOException, FileNotFoundException
   {
      // Memory map the first 2GB segment of the file.
    //FileChannel fc = new FileInputStream("data").getChannel();
      FileChannel fc = new RandomAccessFile("data", "r").getChannel();
      long fileSize = fc.size();
      ByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0, Integer.MAX_VALUE);

      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Search Sequential in Memory Mapped File");
      Instant start = Instant.now();
      int lineNumber = 1;

      for (int i = 0; i < Integer.MAX_VALUE; ++i)
      {
         if ( '\n' == mbb.get(i) )
         {
            ++lineNumber;
         }
         else if ( i < fileSize - 8
                && 'a' == mbb.get(i)
                && 'a' == mbb.get(i+1)
                && 'r' == mbb.get(i+2)
                && 'd' == mbb.get(i+3)
                && 'v' == mbb.get(i+4)
                && 'a' == mbb.get(i+5)
                && 'r' == mbb.get(i+6)
                && 'k' == mbb.get(i+7) )
         {
            System.out.printf("%s line %,d\n", ft.format(new Date()), lineNumber);
         }
      }

      // Memory map the second segment of the file.
      int restOfFile = (int)(fileSize - Integer.MAX_VALUE - 1);
      mbb = fc.map(FileChannel.MapMode.READ_ONLY, 1L + Integer.MAX_VALUE, restOfFile);

      for (int i = 0; i < restOfFile; i++)
      {
         if ( '\n' == mbb.get(i) )
         {
            ++lineNumber;
         }
         else if ( i < fileSize - 8
                && 'a' == mbb.get(i)
                && 'a' == mbb.get(i+1)
                && 'r' == mbb.get(i+2)
                && 'd' == mbb.get(i+3)
                && 'v' == mbb.get(i+4)
                && 'a' == mbb.get(i+5)
                && 'r' == mbb.get(i+6)
                && 'k' == mbb.get(i+7) )
         {
            System.out.printf("%s line %,d\n", ft.format(new Date()), lineNumber);
         }
      }
      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s processed %,d lines.\n", ft.format(new Date()), lineNumber);
      System.out.printf("elapsed time: %,dms\n", time);
      fc.close();
   }
}
