/*
   Sequential search for "aardvark" in one file called "data".

   This version does file I/O using a Scanner wrapped around
   a FileInputStream.
*/

import java.time.Instant;
import java.time.Duration;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.io.IOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.util.Scanner;

public class SearchSequential_v1_File
{
   public static void main(String[] args) throws IOException
   {
    //Scanner scanner = new Scanner(new File("data")); // Why doesn't this work??
      Scanner scanner = new Scanner(new FileInputStream("data"));
    //Scanner scanner = new Scanner(new BufferedInputStream(
    //                              new FileInputStream("data"), BUFFERSIZE));

      final SimpleDateFormat ft = new SimpleDateFormat("hh:mm:ss");
      System.out.println(ft.format(new Date()) + " Search Sequential ver 1 in File");
      Instant start = Instant.now();
      int lineNumber = 0;

      while ( scanner.hasNextLine() ) // this blocks
      {
         ++lineNumber;
         String oneLine = scanner.nextLine();
         // https://stackoverflow.com/questions/7384791/splitting-strings-through-regular-expressions-by-punctuation-and-whitespace-etc
         String[] tokens =  oneLine.trim().split("[\\p{Punct}\\s]+");
         for (String s : tokens)
         {
          //if ( s.equals("aardvark") )
            if ( s.indexOf("aardvark") != -1 )
            {
               System.out.printf("%s line %,d\n", ft.format(new Date()), lineNumber);
            }
         }
      }
      Instant stop = Instant.now();
      long time = Duration.between(start, stop).toMillis();
      System.out.printf("%s processed %,d lines.\n", ft.format(new Date()), lineNumber);
      System.out.printf("elapsed time: %,dms\n", time);
      scanner.close();
   }
}
